/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v110.storage;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v110.browser.model.BrowserContextID;
import org.openqa.selenium.devtools.v110.network.model.Cookie;
import org.openqa.selenium.devtools.v110.network.model.CookieParam;
import org.openqa.selenium.devtools.v110.page.model.FrameId;
import org.openqa.selenium.devtools.v110.storage.model.CacheStorageContentUpdated;
import org.openqa.selenium.devtools.v110.storage.model.CacheStorageListUpdated;
import org.openqa.selenium.devtools.v110.storage.model.IndexedDBContentUpdated;
import org.openqa.selenium.devtools.v110.storage.model.IndexedDBListUpdated;
import org.openqa.selenium.devtools.v110.storage.model.InterestGroupAccessed;
import org.openqa.selenium.devtools.v110.storage.model.InterestGroupDetails;
import org.openqa.selenium.devtools.v110.storage.model.SerializedStorageKey;
import org.openqa.selenium.devtools.v110.storage.model.SharedStorageAccessed;
import org.openqa.selenium.devtools.v110.storage.model.SharedStorageEntry;
import org.openqa.selenium.devtools.v110.storage.model.SharedStorageMetadata;
import org.openqa.selenium.devtools.v110.storage.model.TrustTokens;
import org.openqa.selenium.devtools.v110.storage.model.UsageForType;
import org.openqa.selenium.json.JsonInput;
import shaded.com.google.common.collect.ImmutableMap;
import shaded.com.google.common.reflect.TypeToken;

@Beta
public class Storage {
    public static Command<SerializedStorageKey> getStorageKeyForFrame(FrameId frameId) {
        Objects.requireNonNull(frameId, "frameId is required");
        ImmutableMap.Builder<String, FrameId> params = ImmutableMap.builder();
        params.put("frameId", frameId);
        return new Command<SerializedStorageKey>("Storage.getStorageKeyForFrame", params.build(), ConverterFunctions.map("storageKey", SerializedStorageKey.class));
    }

    public static Command<Void> clearDataForOrigin(String origin, String storageTypes) {
        Objects.requireNonNull(origin, "origin is required");
        Objects.requireNonNull(storageTypes, "storageTypes is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("origin", origin);
        params.put("storageTypes", storageTypes);
        return new Command<Void>("Storage.clearDataForOrigin", params.build());
    }

    public static Command<Void> clearDataForStorageKey(String storageKey, String storageTypes) {
        Objects.requireNonNull(storageKey, "storageKey is required");
        Objects.requireNonNull(storageTypes, "storageTypes is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("storageKey", storageKey);
        params.put("storageTypes", storageTypes);
        return new Command<Void>("Storage.clearDataForStorageKey", params.build());
    }

    public static Command<List<Cookie>> getCookies(Optional<BrowserContextID> browserContextId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        browserContextId.ifPresent(p -> params.put("browserContextId", p));
        return new Command<List<Cookie>>("Storage.getCookies", params.build(), ConverterFunctions.map("cookies", new TypeToken<List<Cookie>>(){}.getType()));
    }

    public static Command<Void> setCookies(List<CookieParam> cookies, Optional<BrowserContextID> browserContextId) {
        Objects.requireNonNull(cookies, "cookies is required");
        ImmutableMap.Builder<String, List<CookieParam>> params = ImmutableMap.builder();
        params.put("cookies", cookies);
        browserContextId.ifPresent(p -> params.put("browserContextId", (List<CookieParam>)p));
        return new Command<Void>("Storage.setCookies", params.build());
    }

    public static Command<Void> clearCookies(Optional<BrowserContextID> browserContextId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        browserContextId.ifPresent(p -> params.put("browserContextId", p));
        return new Command<Void>("Storage.clearCookies", params.build());
    }

    public static Command<GetUsageAndQuotaResponse> getUsageAndQuota(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("origin", origin);
        return new Command<GetUsageAndQuotaResponse>("Storage.getUsageAndQuota", params.build(), input -> (GetUsageAndQuotaResponse)input.read((Type)((Object)GetUsageAndQuotaResponse.class)));
    }

    @Beta
    public static Command<Void> overrideQuotaForOrigin(String origin, Optional<Number> quotaSize) {
        Objects.requireNonNull(origin, "origin is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("origin", origin);
        quotaSize.ifPresent(p -> params.put("quotaSize", (String)p));
        return new Command<Void>("Storage.overrideQuotaForOrigin", params.build());
    }

    public static Command<Void> trackCacheStorageForOrigin(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("origin", origin);
        return new Command<Void>("Storage.trackCacheStorageForOrigin", params.build());
    }

    public static Command<Void> trackCacheStorageForStorageKey(String storageKey) {
        Objects.requireNonNull(storageKey, "storageKey is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("storageKey", storageKey);
        return new Command<Void>("Storage.trackCacheStorageForStorageKey", params.build());
    }

    public static Command<Void> trackIndexedDBForOrigin(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("origin", origin);
        return new Command<Void>("Storage.trackIndexedDBForOrigin", params.build());
    }

    public static Command<Void> trackIndexedDBForStorageKey(String storageKey) {
        Objects.requireNonNull(storageKey, "storageKey is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("storageKey", storageKey);
        return new Command<Void>("Storage.trackIndexedDBForStorageKey", params.build());
    }

    public static Command<Void> untrackCacheStorageForOrigin(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("origin", origin);
        return new Command<Void>("Storage.untrackCacheStorageForOrigin", params.build());
    }

    public static Command<Void> untrackCacheStorageForStorageKey(String storageKey) {
        Objects.requireNonNull(storageKey, "storageKey is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("storageKey", storageKey);
        return new Command<Void>("Storage.untrackCacheStorageForStorageKey", params.build());
    }

    public static Command<Void> untrackIndexedDBForOrigin(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("origin", origin);
        return new Command<Void>("Storage.untrackIndexedDBForOrigin", params.build());
    }

    public static Command<Void> untrackIndexedDBForStorageKey(String storageKey) {
        Objects.requireNonNull(storageKey, "storageKey is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("storageKey", storageKey);
        return new Command<Void>("Storage.untrackIndexedDBForStorageKey", params.build());
    }

    @Beta
    public static Command<List<TrustTokens>> getTrustTokens() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<List<TrustTokens>>("Storage.getTrustTokens", params.build(), ConverterFunctions.map("tokens", new TypeToken<List<TrustTokens>>(){}.getType()));
    }

    @Beta
    public static Command<Boolean> clearTrustTokens(String issuerOrigin) {
        Objects.requireNonNull(issuerOrigin, "issuerOrigin is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("issuerOrigin", issuerOrigin);
        return new Command<Boolean>("Storage.clearTrustTokens", params.build(), ConverterFunctions.map("didDeleteTokens", Boolean.class));
    }

    @Beta
    public static Command<InterestGroupDetails> getInterestGroupDetails(String ownerOrigin, String name) {
        Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        Objects.requireNonNull(name, "name is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("ownerOrigin", ownerOrigin);
        params.put("name", name);
        return new Command<InterestGroupDetails>("Storage.getInterestGroupDetails", params.build(), ConverterFunctions.map("details", InterestGroupDetails.class));
    }

    @Beta
    public static Command<Void> setInterestGroupTracking(Boolean enable) {
        Objects.requireNonNull(enable, "enable is required");
        ImmutableMap.Builder<String, Boolean> params = ImmutableMap.builder();
        params.put("enable", enable);
        return new Command<Void>("Storage.setInterestGroupTracking", params.build());
    }

    @Beta
    public static Command<SharedStorageMetadata> getSharedStorageMetadata(String ownerOrigin) {
        Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("ownerOrigin", ownerOrigin);
        return new Command<SharedStorageMetadata>("Storage.getSharedStorageMetadata", params.build(), ConverterFunctions.map("metadata", SharedStorageMetadata.class));
    }

    @Beta
    public static Command<List<SharedStorageEntry>> getSharedStorageEntries(String ownerOrigin) {
        Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("ownerOrigin", ownerOrigin);
        return new Command<List<SharedStorageEntry>>("Storage.getSharedStorageEntries", params.build(), ConverterFunctions.map("entries", new TypeToken<List<SharedStorageEntry>>(){}.getType()));
    }

    @Beta
    public static Command<Void> setSharedStorageEntry(String ownerOrigin, String key, String value, Optional<Boolean> ignoreIfPresent) {
        Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        Objects.requireNonNull(key, "key is required");
        Objects.requireNonNull(value, "value is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("ownerOrigin", ownerOrigin);
        params.put("key", key);
        params.put("value", value);
        ignoreIfPresent.ifPresent(p -> params.put("ignoreIfPresent", (String)p));
        return new Command<Void>("Storage.setSharedStorageEntry", params.build());
    }

    @Beta
    public static Command<Void> deleteSharedStorageEntry(String ownerOrigin, String key) {
        Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        Objects.requireNonNull(key, "key is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("ownerOrigin", ownerOrigin);
        params.put("key", key);
        return new Command<Void>("Storage.deleteSharedStorageEntry", params.build());
    }

    @Beta
    public static Command<Void> clearSharedStorageEntries(String ownerOrigin) {
        Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("ownerOrigin", ownerOrigin);
        return new Command<Void>("Storage.clearSharedStorageEntries", params.build());
    }

    @Beta
    public static Command<Void> setSharedStorageTracking(Boolean enable) {
        Objects.requireNonNull(enable, "enable is required");
        ImmutableMap.Builder<String, Boolean> params = ImmutableMap.builder();
        params.put("enable", enable);
        return new Command<Void>("Storage.setSharedStorageTracking", params.build());
    }

    public static Event<CacheStorageContentUpdated> cacheStorageContentUpdated() {
        return new Event<CacheStorageContentUpdated>("Storage.cacheStorageContentUpdated", input -> (CacheStorageContentUpdated)input.read((Type)((Object)CacheStorageContentUpdated.class)));
    }

    public static Event<CacheStorageListUpdated> cacheStorageListUpdated() {
        return new Event<CacheStorageListUpdated>("Storage.cacheStorageListUpdated", input -> (CacheStorageListUpdated)input.read((Type)((Object)CacheStorageListUpdated.class)));
    }

    public static Event<IndexedDBContentUpdated> indexedDBContentUpdated() {
        return new Event<IndexedDBContentUpdated>("Storage.indexedDBContentUpdated", input -> (IndexedDBContentUpdated)input.read((Type)((Object)IndexedDBContentUpdated.class)));
    }

    public static Event<IndexedDBListUpdated> indexedDBListUpdated() {
        return new Event<IndexedDBListUpdated>("Storage.indexedDBListUpdated", input -> (IndexedDBListUpdated)input.read((Type)((Object)IndexedDBListUpdated.class)));
    }

    public static Event<InterestGroupAccessed> interestGroupAccessed() {
        return new Event<InterestGroupAccessed>("Storage.interestGroupAccessed", input -> (InterestGroupAccessed)input.read((Type)((Object)InterestGroupAccessed.class)));
    }

    public static Event<SharedStorageAccessed> sharedStorageAccessed() {
        return new Event<SharedStorageAccessed>("Storage.sharedStorageAccessed", input -> (SharedStorageAccessed)input.read((Type)((Object)SharedStorageAccessed.class)));
    }

    public static class GetUsageAndQuotaResponse {
        private final Number usage;
        private final Number quota;
        private final Boolean overrideActive;
        private final List<UsageForType> usageBreakdown;

        public GetUsageAndQuotaResponse(Number usage, Number quota, Boolean overrideActive, List<UsageForType> usageBreakdown) {
            this.usage = Objects.requireNonNull(usage, "usage is required");
            this.quota = Objects.requireNonNull(quota, "quota is required");
            this.overrideActive = Objects.requireNonNull(overrideActive, "overrideActive is required");
            this.usageBreakdown = Objects.requireNonNull(usageBreakdown, "usageBreakdown is required");
        }

        public Number getUsage() {
            return this.usage;
        }

        public Number getQuota() {
            return this.quota;
        }

        public Boolean getOverrideActive() {
            return this.overrideActive;
        }

        public List<UsageForType> getUsageBreakdown() {
            return this.usageBreakdown;
        }

        private static GetUsageAndQuotaResponse fromJson(JsonInput input) {
            Number usage = 0;
            Number quota = 0;
            Boolean overrideActive = false;
            List usageBreakdown = null;
            input.beginObject();
            block12: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "usage": {
                        usage = input.nextNumber();
                        continue block12;
                    }
                    case "quota": {
                        quota = input.nextNumber();
                        continue block12;
                    }
                    case "overrideActive": {
                        overrideActive = input.nextBoolean();
                        continue block12;
                    }
                    case "usageBreakdown": {
                        usageBreakdown = (List)input.read(new TypeToken<List<UsageForType>>(){}.getType());
                        continue block12;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetUsageAndQuotaResponse(usage, quota, overrideActive, usageBreakdown);
        }
    }
}

