/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v110.storage.model;

import java.lang.reflect.Type;
import java.util.Objects;
import org.openqa.selenium.devtools.v110.network.model.TimeSinceEpoch;
import org.openqa.selenium.json.JsonInput;

public class SharedStorageMetadata {
    private final TimeSinceEpoch creationTime;
    private final Integer length;
    private final Number remainingBudget;

    public SharedStorageMetadata(TimeSinceEpoch creationTime, Integer length, Number remainingBudget) {
        this.creationTime = Objects.requireNonNull(creationTime, "creationTime is required");
        this.length = Objects.requireNonNull(length, "length is required");
        this.remainingBudget = Objects.requireNonNull(remainingBudget, "remainingBudget is required");
    }

    public TimeSinceEpoch getCreationTime() {
        return this.creationTime;
    }

    public Integer getLength() {
        return this.length;
    }

    public Number getRemainingBudget() {
        return this.remainingBudget;
    }

    private static SharedStorageMetadata fromJson(JsonInput input) {
        TimeSinceEpoch creationTime = null;
        Integer length = 0;
        Number remainingBudget = 0;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "creationTime": {
                    creationTime = (TimeSinceEpoch)input.read((Type)((Object)TimeSinceEpoch.class));
                    continue block10;
                }
                case "length": {
                    length = input.nextNumber().intValue();
                    continue block10;
                }
                case "remainingBudget": {
                    remainingBudget = input.nextNumber();
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new SharedStorageMetadata(creationTime, length, remainingBudget);
    }
}

