/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Base64;
import java.util.function.Supplier;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.JsonOutput;
import org.openqa.selenium.remote.http.HttpMessage;
import shaded.com.google.common.io.ByteStreams;
import shaded.com.google.common.io.FileBackedOutputStream;

public class Contents {
    private static final Json JSON = new Json();

    private Contents() {
    }

    public static Supplier<InputStream> empty() {
        return Contents.bytes(new byte[0]);
    }

    public static Supplier<InputStream> utf8String(CharSequence value) {
        Require.nonNull("Value to return", value);
        return Contents.string(value, StandardCharsets.UTF_8);
    }

    public static Supplier<InputStream> string(CharSequence value, Charset charset) {
        Require.nonNull("Value to return", value);
        Require.nonNull("Character set", charset);
        return Contents.bytes(value.toString().getBytes(charset));
    }

    public static Supplier<InputStream> bytes(byte[] bytes) {
        Require.nonNull("Bytes to return", bytes, "may be empty", new Object[0]);
        return () -> new ByteArrayInputStream(bytes);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] bytes(Supplier<InputStream> supplier) {
        Require.nonNull("Supplier of input", supplier);
        try (InputStream is = supplier.get();){
            byte[] byArray;
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                ByteStreams.copy(is, bos);
                byArray = bos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String utf8String(Supplier<InputStream> supplier) {
        return Contents.string(supplier, StandardCharsets.UTF_8);
    }

    public static String string(Supplier<InputStream> supplier, Charset charset) {
        Require.nonNull("Supplier of input", supplier);
        Require.nonNull("Character set", charset);
        return new String(Contents.bytes(supplier), charset);
    }

    public static String string(HttpMessage<?> message) {
        return Contents.string(message.getContent(), message.getContentEncoding());
    }

    public static Reader utf8Reader(Supplier<InputStream> supplier) {
        Require.nonNull("Supplier", supplier);
        return Contents.reader(supplier, StandardCharsets.UTF_8);
    }

    public static Reader reader(Supplier<InputStream> supplier, Charset charset) {
        Require.nonNull("Supplier of input", supplier);
        Require.nonNull("Character set", charset);
        return new InputStreamReader(supplier.get(), charset);
    }

    public static Reader reader(HttpMessage<?> message) {
        return Contents.reader(message.getContent(), message.getContentEncoding());
    }

    public static Supplier<InputStream> asJson(Object obj) {
        StringBuilder builder = new StringBuilder();
        try (JsonOutput out = JSON.newOutput(builder);){
            out.writeClassName(false);
            out.write(obj);
        }
        return Contents.utf8String(builder);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T> T fromJson(HttpMessage<?> message, Type typeOfT) {
        try (Reader reader = Contents.reader(message);){
            Object t;
            block14: {
                JsonInput input = JSON.newInput(reader);
                try {
                    t = input.read(typeOfT);
                    if (input == null) break block14;
                    input.close();
                }
                catch (Throwable throwable) {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            return t;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Supplier<InputStream> memoize(Supplier<InputStream> delegate) {
        return new MemoizedSupplier(delegate);
    }

    public static String string(File input) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            String string;
            block12: {
                InputStream isr = Files.newInputStream(input.toPath(), new OpenOption[0]);
                try {
                    int len;
                    byte[] buffer = new byte[4096];
                    while ((len = isr.read(buffer)) != -1) {
                        bos.write(buffer, 0, len);
                    }
                    string = Base64.getEncoder().encodeToString(bos.toByteArray());
                    if (isr == null) break block12;
                }
                catch (Throwable throwable) {
                    if (isr != null) {
                        try {
                            isr.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                isr.close();
            }
            return string;
        }
    }

    private static final class MemoizedSupplier
    implements Supplier<InputStream> {
        private volatile boolean initialized;
        private volatile FileBackedOutputStream fos;
        private Supplier<InputStream> delegate;

        private MemoizedSupplier(Supplier<InputStream> delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InputStream get() {
            if (!this.initialized) {
                MemoizedSupplier memoizedSupplier = this;
                synchronized (memoizedSupplier) {
                    if (!this.initialized) {
                        try (InputStream is = this.delegate.get();){
                            this.fos = new FileBackedOutputStream(0x300000, true);
                            ByteStreams.copy(is, this.fos);
                            this.initialized = true;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                        finally {
                            try {
                                this.fos.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            }
            try {
                return Require.state("Source", this.fos.asByteSource()).nonNull().openBufferedStream();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

