/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.ashot.shooting;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Set;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import ru.yandex.qatools.ashot.coordinates.Coords;
import ru.yandex.qatools.ashot.shooting.ShootingDecorator;
import ru.yandex.qatools.ashot.shooting.ShootingStrategy;
import ru.yandex.qatools.ashot.util.InnerScript;

public class ViewportPastingDecorator
extends ShootingDecorator {
    protected int scrollTimeout = 0;
    private Coords shootingArea;

    public ViewportPastingDecorator(ShootingStrategy strategy) {
        super(strategy);
    }

    public ViewportPastingDecorator withScrollTimeout(int scrollTimeout) {
        this.scrollTimeout = scrollTimeout;
        return this;
    }

    @Override
    public BufferedImage getScreenshot(WebDriver wd) {
        return this.getScreenshot(wd, null);
    }

    @Override
    public BufferedImage getScreenshot(WebDriver wd, Set<Coords> coordsSet) {
        JavascriptExecutor js = (JavascriptExecutor)((Object)wd);
        int pageHeight = this.getFullHeight(wd);
        int pageWidth = this.getFullWidth(wd);
        int viewportHeight = this.getWindowHeight(wd);
        this.shootingArea = this.getShootingCoords(coordsSet, pageWidth, pageHeight, viewportHeight);
        BufferedImage finalImage = new BufferedImage(pageWidth, this.shootingArea.height, 5);
        Graphics2D graphics = finalImage.createGraphics();
        int scrollTimes = (int)Math.ceil(this.shootingArea.getHeight() / (double)viewportHeight);
        for (int n = 0; n < scrollTimes; ++n) {
            this.scrollVertically(js, this.shootingArea.y + viewportHeight * n);
            this.waitForScrolling();
            BufferedImage part = this.getShootingStrategy().getScreenshot(wd);
            graphics.drawImage((Image)part, 0, this.getCurrentScrollY(js) - this.shootingArea.y, null);
        }
        graphics.dispose();
        return finalImage;
    }

    @Override
    public Set<Coords> prepareCoords(Set<Coords> coordsSet) {
        return this.shootingArea == null ? coordsSet : this.shiftCoords(coordsSet, this.shootingArea);
    }

    public int getFullHeight(WebDriver driver) {
        return ((Number)InnerScript.execute("js/page_height.js", driver, new Object[0])).intValue();
    }

    public int getFullWidth(WebDriver driver) {
        return ((Number)InnerScript.execute("js/viewport_width.js", driver, new Object[0])).intValue();
    }

    public int getWindowHeight(WebDriver driver) {
        return ((Number)InnerScript.execute("js/viewport_height.js", driver, new Object[0])).intValue();
    }

    protected int getCurrentScrollY(JavascriptExecutor js) {
        return ((Number)js.executeScript("var scrY = window.scrollY;if(scrY){return scrY;} else {return 0;}", new Object[0])).intValue();
    }

    protected void scrollVertically(JavascriptExecutor js, int scrollY) {
        js.executeScript("scrollTo(0, arguments[0]); return [];", scrollY);
    }

    private Coords getShootingCoords(Set<Coords> coords, int pageWidth, int pageHeight, int viewPortHeight) {
        if (coords == null || coords.isEmpty()) {
            return new Coords(0, 0, pageWidth, pageHeight);
        }
        return this.extendShootingArea(Coords.unity(coords), viewPortHeight, pageHeight);
    }

    private Set<Coords> shiftCoords(Set<Coords> coordsSet, Coords shootingArea) {
        HashSet<Coords> shiftedCoords = new HashSet<Coords>();
        if (coordsSet != null) {
            for (Coords coords : coordsSet) {
                coords.y -= shootingArea.y;
                shiftedCoords.add(coords);
            }
        }
        return shiftedCoords;
    }

    private Coords extendShootingArea(Coords shootingCoords, int viewportHeight, int pageHeight) {
        int halfViewport = viewportHeight / 2;
        shootingCoords.y = Math.max(shootingCoords.y - halfViewport / 2, 0);
        shootingCoords.height = Math.min(shootingCoords.height + halfViewport, pageHeight);
        return shootingCoords;
    }

    private void waitForScrolling() {
        try {
            Thread.sleep(this.scrollTimeout);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Exception while waiting for scrolling", e);
        }
    }
}

