/*
 * Decompiled with CFR 0.152.
 */
package org.ndviet.library;

import java.net.URL;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ndviet.library.configuration.ConfigurationFactory;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.remote.AbstractDriverOptions;
import org.openqa.selenium.remote.RemoteWebDriver;

public class Browser {
    private static final Logger LOGGER = LogManager.getLogger(Browser.class);

    public static boolean getEnableTracing() {
        return Boolean.parseBoolean(ConfigurationFactory.getInstance().getValue("selenium.enableTracing"));
    }

    public static boolean isRemoteWebDriver() {
        if (StringUtils.isEmpty((CharSequence)ConfigurationFactory.getInstance().getValue("selenium.web_driver.type"))) {
            return false;
        }
        return ConfigurationFactory.getInstance().getValue("selenium.web_driver.type").equalsIgnoreCase(DRIVER_TYPE.REMOTE.toString());
    }

    public static RemoteWebDriver getRemoteWebDriver(AbstractDriverOptions options) {
        try {
            String hubUrl = ConfigurationFactory.getInstance().getValue("selenium.hub.url");
            return new RemoteWebDriver(new URL(hubUrl), (Capabilities)options, Browser.getEnableTracing());
        }
        catch (Exception e) {
            LOGGER.error("Could not open the browser.\n" + e.getMessage());
            return null;
        }
    }

    private static interface BrowserType {
        public WebDriver openBrowser();

        public String getName();
    }

    public static enum DRIVER_TYPE {
        LOCAL("local"),
        REMOTE("remote");

        private final String value;

        private DRIVER_TYPE(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    protected static enum Type implements BrowserType
    {
        CHROME{

            @Override
            public WebDriver openBrowser() {
                ChromeOptions options = new ChromeOptions();
                List listArgs = ConfigurationFactory.getInstance().getListValues("selenium.browser.chrome.args");
                options.addArguments(listArgs.toArray(new String[0]));
                if (Browser.isRemoteWebDriver()) {
                    return Browser.getRemoteWebDriver((AbstractDriverOptions)options);
                }
                return new ChromeDriver(options);
            }

            @Override
            public String getName() {
                return "chrome";
            }
        }
        ,
        FIREFOX{

            @Override
            public WebDriver openBrowser() {
                FirefoxOptions options = new FirefoxOptions();
                List listArgs = ConfigurationFactory.getInstance().getListValues("selenium.browser.firefox.args");
                options.addArguments(listArgs.toArray(new String[0]));
                if (Browser.isRemoteWebDriver()) {
                    return Browser.getRemoteWebDriver((AbstractDriverOptions)options);
                }
                return new FirefoxDriver(options);
            }

            @Override
            public String getName() {
                return "firefox";
            }
        };

    }
}

