/*
 * Decompiled with CFR 0.152.
 */
package org.ndviet.library;

import java.time.Duration;
import java.util.List;
import java.util.function.Function;
import org.ndviet.library.WebElementHelpers;
import org.ndviet.library.configuration.ConfigurationManager;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class Waiting {
    private static final String configDefaultTimeOut = ConfigurationManager.getInstance().getValue("selenium.default.timeOut");
    public static int m_defaultTimeOut = configDefaultTimeOut == null ? 10 : Integer.parseInt(configDefaultTimeOut);

    public static WebDriverWait getWaitDriver(WebDriver driver, boolean isWait) {
        return Waiting.getWaitDriver(driver, isWait, m_defaultTimeOut);
    }

    public static WebDriverWait getWaitDriver(WebDriver driver, boolean isWait, int timeOut) {
        WebDriverWait wait = isWait ? (timeOut >= 0 ? new WebDriverWait(driver, Duration.ofSeconds(timeOut)) : Waiting.getWaitDriver(driver, true)) : new WebDriverWait(driver, Duration.ZERO);
        return wait;
    }

    private static interface WaitElementCondition {
        public boolean waitForElement(WebDriver var1, Object var2, boolean var3, int var4, String var5);
    }

    private static interface WaitElements {
        public List<WebElement> waitForElements(WebDriver var1, Object var2, boolean var3, int var4);
    }

    private static interface WaitElement {
        public WebElement waitForElement(WebDriver var1, Object var2, boolean var3, int var4);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    protected static enum Condition implements WaitElementCondition
    {
        INVISIBILITY_OF_ELEMENT_LOCATED{

            @Override
            public boolean waitForElement(WebDriver driver, Object object, boolean isWait, int timeOut, String expectText) {
                return (Boolean)Waiting.getWaitDriver(driver, isWait, timeOut).until((Function)ExpectedConditions.refreshed((ExpectedCondition)ExpectedConditions.invisibilityOfElementLocated((By)WebElementHelpers.getBy(object))));
            }
        }
        ,
        NOT_PRESENCE_OF_ELEMENT_LOCATED{

            @Override
            public boolean waitForElement(WebDriver driver, Object object, boolean isWait, int timeOut, String expectText) {
                return (Boolean)Waiting.getWaitDriver(driver, isWait, timeOut).until((Function)ExpectedConditions.not((ExpectedCondition)ExpectedConditions.presenceOfElementLocated((By)WebElementHelpers.getBy(object))));
            }
        }
        ,
        TEXT_TO_BE_PRESENT_IN_ELEMENT_LOCATED{

            @Override
            public boolean waitForElement(WebDriver driver, Object object, boolean isWait, int timeOut, String expectText) {
                return (Boolean)Waiting.getWaitDriver(driver, isWait, timeOut).until((Function)ExpectedConditions.refreshed((ExpectedCondition)ExpectedConditions.textToBePresentInElementLocated((By)WebElementHelpers.getBy(object), (String)expectText)));
            }
        }
        ,
        TEXT_TO_BE_PRESENT_IN_ELEMENT{

            @Override
            public boolean waitForElement(WebDriver driver, Object object, boolean isWait, int timeOut, String expectText) {
                return (Boolean)Waiting.getWaitDriver(driver, isWait, timeOut).until((Function)ExpectedConditions.refreshed((ExpectedCondition)ExpectedConditions.textToBePresentInElement((WebElement)((WebElement)ExpectedConditions.presenceOfElementLocated((By)WebElementHelpers.getBy(object)).apply((Object)driver)), (String)expectText)));
            }
        };

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    protected static enum Elements implements WaitElements
    {
        PRESENCE_OF_ALL_ELEMENTS_LOCATED{

            @Override
            public List<WebElement> waitForElements(WebDriver driver, Object object, boolean isWait, int timeOut) {
                return (List)Waiting.getWaitDriver(driver, isWait, timeOut).until((Function)ExpectedConditions.presenceOfAllElementsLocatedBy((By)WebElementHelpers.getBy(object)));
            }
        }
        ,
        VISIBILITY_OF_ALL_ELEMENTS_LOCATED_BY{

            @Override
            public List<WebElement> waitForElements(WebDriver driver, Object object, boolean isWait, int timeOut) {
                return (List)Waiting.getWaitDriver(driver, isWait, timeOut).until((Function)ExpectedConditions.visibilityOfAllElementsLocatedBy((By)WebElementHelpers.getBy(object)));
            }
        };

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    protected static enum Element implements WaitElement
    {
        PRESENCE_OF_ELEMENT_LOCATED{

            @Override
            public WebElement waitForElement(WebDriver driver, Object object, boolean isWait, int timeOut) {
                return (WebElement)Waiting.getWaitDriver(driver, isWait, timeOut).until((Function)ExpectedConditions.refreshed((ExpectedCondition)ExpectedConditions.presenceOfElementLocated((By)WebElementHelpers.getBy(object))));
            }
        }
        ,
        ELEMENT_TO_BE_CLICKABLE{

            @Override
            public WebElement waitForElement(WebDriver driver, Object object, boolean isWait, int timeOut) {
                return (WebElement)Waiting.getWaitDriver(driver, isWait, timeOut).until((Function)ExpectedConditions.refreshed((ExpectedCondition)ExpectedConditions.elementToBeClickable((WebElement)((WebElement)ExpectedConditions.presenceOfElementLocated((By)WebElementHelpers.getBy(object)).apply((Object)driver)))));
            }
        }
        ,
        VISIBILITY_OF{

            @Override
            public WebElement waitForElement(WebDriver driver, Object object, boolean isWait, int timeOut) {
                return (WebElement)Waiting.getWaitDriver(driver, isWait, timeOut).until((Function)ExpectedConditions.refreshed((ExpectedCondition)ExpectedConditions.visibilityOf((WebElement)((WebElement)ExpectedConditions.presenceOfElementLocated((By)WebElementHelpers.getBy(object)).apply((Object)driver)))));
            }
        }
        ,
        VISIBILITY_OF_ELEMENT_LOCATED{

            @Override
            public WebElement waitForElement(WebDriver driver, Object object, boolean isWait, int timeOut) {
                return (WebElement)Waiting.getWaitDriver(driver, isWait, timeOut).until((Function)ExpectedConditions.refreshed((ExpectedCondition)ExpectedConditions.visibilityOfElementLocated((By)WebElementHelpers.getBy(object))));
            }
        };

    }
}

