/*
 * Decompiled with CFR 0.152.
 */
package org.ndviet.library.webui.driver;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ndviet.library.configuration.ConfigurationManager;
import org.ndviet.library.webui.driver.BrowserFactory;
import org.ndviet.library.webui.driver.RemoteDriverFactory;
import org.openqa.selenium.WebDriver;

public class TargetFactory {
    private static final Logger LOGGER = LogManager.getLogger(TargetFactory.class);

    public static WebDriver createInstance() {
        String browser = ConfigurationManager.getInstance().getValue("selenium.browser.type");
        String target = ConfigurationManager.getInstance().getValue("selenium.web_driver.target");
        return TargetFactory.createInstance(browser, target);
    }

    public static WebDriver createInstance(String browser) {
        String target = ConfigurationManager.getInstance().getValue("selenium.web_driver.target");
        return TargetFactory.createInstance(browser, target);
    }

    public static WebDriver createInstance(String browser, String target) {
        Target instance = Target.valueOf(target.toUpperCase());
        switch (instance) {
            case LOCAL: {
                return BrowserFactory.valueOf(browser.toUpperCase()).createLocalDriver();
            }
            case REMOTE: {
                return RemoteDriverFactory.createRemoteInstance(browser);
            }
        }
        throw new RuntimeException("Target is still not support!");
    }

    public static boolean isRemoteTarget() {
        String target = ConfigurationManager.getInstance().getValue("selenium.web_driver.target");
        return Target.valueOf(target.toUpperCase()) == Target.REMOTE;
    }

    public static enum Target {
        LOCAL,
        REMOTE;

    }
}

