/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.service.helper;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.nentangso.core.annotation.OptionProperties;
import org.nentangso.core.domain.NtsOptionEntity;
import org.nentangso.core.repository.NtsOptionRepository;
import org.nentangso.core.service.errors.FormValidationException;
import org.nentangso.core.service.utils.NtsTextUtils;
import org.nentangso.core.service.utils.NtsValidationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@ConditionalOnProperty(prefix="nts.helper.option", name={"enabled"}, havingValue="true")
@Service
public class NtsOptionHelper {
    private static final Logger log = LoggerFactory.getLogger(NtsOptionHelper.class);
    private final NtsOptionRepository optionRepository;

    public NtsOptionHelper(NtsOptionRepository optionRepository) {
        this.optionRepository = optionRepository;
    }

    public Optional<String> readRawString(String optionKey) {
        if (StringUtils.isBlank((CharSequence)optionKey)) {
            return Optional.empty();
        }
        return this.optionRepository.findOneByOptionKey(optionKey).map(NtsOptionEntity::getOptionValue);
    }

    @Transactional
    public void writeRawString(String optionKey, String optionValue) {
        if (StringUtils.isBlank((CharSequence)optionKey)) {
            throw new FormValidationException("option_key", "Option key is invalid");
        }
        NtsOptionEntity option = this.optionRepository.findOneByOptionKey(optionKey).orElseGet(() -> new NtsOptionEntity(optionKey, optionValue));
        option.setOptionValue(optionValue);
        this.optionRepository.save(option);
    }

    public Optional<Boolean> readBoolean(String optionKey) {
        return this.readRawString(optionKey).map(Boolean::parseBoolean);
    }

    @Transactional
    public void writeBoolean(String optionKey, Boolean value) {
        String rawString = value == null ? null : String.valueOf(value);
        this.writeRawString(optionKey, rawString);
    }

    public Optional<Long> readLong(String optionKey) {
        return this.readRawString(optionKey).map(Long::parseLong);
    }

    @Transactional
    public void writeLong(String optionKey, Long value) {
        String rawString = value == null ? null : String.valueOf(value);
        this.writeRawString(optionKey, rawString);
    }

    public Optional<Integer> readInteger(String optionKey) {
        return this.readRawString(optionKey).map(Integer::parseInt);
    }

    @Transactional
    public void writeInteger(String optionKey, Integer value) {
        String rawString = value == null ? null : String.valueOf(value);
        this.writeRawString(optionKey, rawString);
    }

    public Optional<Float> readFloat(String optionKey) {
        return this.readRawString(optionKey).map(Float::parseFloat);
    }

    @Transactional
    public void writeFloat(String optionKey, Float value) {
        String rawString = value == null ? null : String.valueOf(value);
        this.writeRawString(optionKey, rawString);
    }

    public Optional<Double> readDouble(String optionKey) {
        return this.readRawString(optionKey).map(Double::parseDouble);
    }

    @Transactional
    public void writeUUID(String optionKey, UUID value) {
        String rawString = value == null ? null : String.valueOf(value);
        this.writeRawString(optionKey, rawString);
    }

    public Optional<UUID> readUUID(String optionKey) {
        return this.readRawString(optionKey).map(UUID::fromString);
    }

    @Transactional
    public void writeBigDecimal(String optionKey, BigDecimal value) {
        String rawString = value == null ? null : String.valueOf(value);
        this.writeRawString(optionKey, rawString);
    }

    public Optional<BigDecimal> readBigDecimal(String optionKey) {
        return this.readRawString(optionKey).map(BigDecimal::new);
    }

    @Transactional
    public void writeDouble(String optionKey, Double value) {
        String rawString = value == null ? null : String.valueOf(value);
        this.writeRawString(optionKey, rawString);
    }

    public <T> Optional<T> read(Class<T> clazz) {
        T output;
        if (clazz == null) {
            log.warn("Class cannot be null");
            return Optional.empty();
        }
        String prefix = this.getPrefix(clazz);
        try {
            output = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.warn("Class must has constructor without parameters");
            return Optional.empty();
        }
        Set<String> optionKeys = Stream.of(clazz.getDeclaredFields()).map(field -> this.generateOptionKey((Field)field, prefix)).collect(Collectors.toSet());
        List<NtsOptionEntity> options = this.optionRepository.findByOptionKeyIn(optionKeys);
        if (options.isEmpty()) {
            NtsValidationUtils.validateObject(output);
            return Optional.of(output);
        }
        for (Field field2 : clazz.getDeclaredFields()) {
            try {
                this.setValues(output, field2, options, prefix);
            }
            catch (IllegalAccessException e) {
                log.warn("Cannot set field " + field2.getName());
                return Optional.empty();
            }
        }
        NtsValidationUtils.validateObject(output);
        return Optional.of(output);
    }

    private String getPrefix(Class<?> clazz) {
        OptionProperties optionProperties = clazz.getAnnotation(OptionProperties.class);
        if (optionProperties == null) {
            log.warn("Class must has annotation OptionProperties");
            return "";
        }
        String prefix = Optional.of(optionProperties.prefix()).filter(StringUtils::isNotBlank).map(m -> StringUtils.trim((String)m) + ".").orElse("");
        return prefix;
    }

    private <T> void setValues(T output, Field field, List<NtsOptionEntity> options, String prefix) throws IllegalAccessException {
        String optionKey = this.generateOptionKey(field, prefix);
        Type genericType = field.getGenericType();
        if (genericType instanceof ParameterizedType) {
            Collection fieldValues;
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            String typeName = parameterizedType.getRawType().getTypeName();
            String childrenTypeName = parameterizedType.getActualTypeArguments()[0].getTypeName();
            List values = options.stream().filter(f -> StringUtils.equals((CharSequence)f.getOptionKey(), (CharSequence)optionKey)).map(NtsOptionEntity::getOptionValue).filter(Objects::nonNull).map(rawString -> this.parseValue(field, (String)rawString, childrenTypeName)).collect(Collectors.toList());
            if (StringUtils.equals((CharSequence)typeName, (CharSequence)List.class.getTypeName())) {
                fieldValues = values;
            } else if (StringUtils.equals((CharSequence)typeName, (CharSequence)Set.class.getTypeName())) {
                fieldValues = new HashSet(values);
            } else {
                throw new ClassCastException("Type of " + field.getName() + " is not supported");
            }
            field.setAccessible(true);
            field.set(output, fieldValues);
        } else {
            String rawString2 = options.stream().filter(f -> StringUtils.equals((CharSequence)f.getOptionKey(), (CharSequence)optionKey)).map(NtsOptionEntity::getOptionValue).filter(Objects::nonNull).findFirst().orElse(null);
            if (rawString2 == null) {
                return;
            }
            Object value = this.parseValue(field, rawString2, field.getType().getTypeName());
            field.setAccessible(true);
            field.set(output, value);
        }
    }

    private Object parseValue(Field field, String rawString, String typeName) {
        Object value;
        if (StringUtils.equals((CharSequence)typeName, (CharSequence)String.class.getTypeName())) {
            value = rawString;
        } else if (StringUtils.equalsAny((CharSequence)typeName, (CharSequence[])new CharSequence[]{Integer.class.getTypeName(), "int"})) {
            value = Integer.parseInt(rawString);
        } else if (StringUtils.equalsAny((CharSequence)typeName, (CharSequence[])new CharSequence[]{Long.class.getTypeName(), "long"})) {
            value = Long.parseLong(rawString);
        } else if (StringUtils.equalsAny((CharSequence)typeName, (CharSequence[])new CharSequence[]{Float.class.getTypeName(), "float"})) {
            value = Float.valueOf(Float.parseFloat(rawString));
        } else if (StringUtils.equalsAny((CharSequence)typeName, (CharSequence[])new CharSequence[]{Double.class.getTypeName(), "double"})) {
            value = Double.parseDouble(rawString);
        } else if (StringUtils.equals((CharSequence)typeName, (CharSequence)BigDecimal.class.getTypeName())) {
            value = new BigDecimal(rawString);
        } else {
            throw new ClassCastException("Type of " + field.getName() + " is not supported");
        }
        return value;
    }

    private String generateOptionKey(Field field, String prefix) {
        String optionKey = StringUtils.join((Object[])new String[]{prefix, NtsTextUtils.toSnakeCase((String)field.getName())});
        Type genericType = field.getGenericType();
        if (genericType instanceof ParameterizedType ? this.isSupportedGenericType((ParameterizedType)genericType) : this.isSupportedTypeName(field.getType().getTypeName())) {
            return optionKey;
        }
        throw new ClassCastException("Type of " + field.getName() + " is not supported");
    }

    private boolean isSupportedGenericType(ParameterizedType parameterizedType) {
        String typeName = parameterizedType.getRawType().getTypeName();
        if (StringUtils.equalsAny((CharSequence)typeName, (CharSequence[])new CharSequence[]{List.class.getTypeName(), Set.class.getTypeName()})) {
            String childrenTypeName = parameterizedType.getActualTypeArguments()[0].getTypeName();
            return this.isSupportedTypeName(childrenTypeName);
        }
        return false;
    }

    private boolean isSupportedTypeName(String typeName) {
        return StringUtils.equalsAny((CharSequence)typeName, (CharSequence[])new CharSequence[]{String.class.getTypeName(), Integer.class.getTypeName(), "int", Long.class.getTypeName(), "long", Float.class.getTypeName(), "float", Double.class.getTypeName(), "double", BigDecimal.class.getTypeName()});
    }

    @Transactional
    public <T> void write(T configuration) {
        if (configuration == null) {
            log.warn("Configuration cannot be null");
            return;
        }
        NtsValidationUtils.validateObject(configuration);
        Class<?> clazz = configuration.getClass();
        String prefix = this.getPrefix(clazz);
        ArrayList<NtsOptionEntity> options = new ArrayList<NtsOptionEntity>();
        HashSet<String> optionKeys = new HashSet<String>();
        for (Field field : clazz.getDeclaredFields()) {
            String optionKey = this.generateOptionKey(field, prefix);
            optionKeys.add(optionKey);
            try {
                field.setAccessible(true);
                Type genericType = field.getGenericType();
                if (genericType instanceof ParameterizedType) {
                    ParameterizedType parameterizedType = (ParameterizedType)genericType;
                    Collection values = (Collection)field.get(configuration);
                    String childrenTypeName = parameterizedType.getActualTypeArguments()[0].getTypeName();
                    values.forEach(value -> options.add(new NtsOptionEntity(optionKey, this.convertValue(value, childrenTypeName))));
                    continue;
                }
                Object value2 = field.get(configuration);
                String rawValue = this.convertValue(value2, field.getType().getTypeName());
                options.add(new NtsOptionEntity(optionKey, rawValue));
            }
            catch (IllegalAccessException e) {
                throw new ClassCastException("Type of " + field.getName() + " is not supported");
            }
        }
        this.save(optionKeys, options);
    }

    private void save(Set<String> optionKeys, List<NtsOptionEntity> options) {
        List<NtsOptionEntity> existOptions = this.optionRepository.findByOptionKeyIn(optionKeys);
        ArrayList<NtsOptionEntity> addingOptions = new ArrayList<NtsOptionEntity>();
        for (NtsOptionEntity option : options) {
            NtsOptionEntity existOption = existOptions.stream().filter(f -> StringUtils.equals((CharSequence)f.getOptionKey(), (CharSequence)option.getOptionKey()) && StringUtils.equals((CharSequence)f.getOptionValue(), (CharSequence)option.getOptionValue())).findFirst().orElse(null);
            if (existOption != null) {
                existOptions.remove(existOption);
                continue;
            }
            addingOptions.add(option);
        }
        this.optionRepository.deleteAll(existOptions);
        this.optionRepository.saveAll(addingOptions);
        this.optionRepository.flush();
    }

    private String convertValue(Object value, String typeName) {
        String rawString;
        if (StringUtils.equals((CharSequence)typeName, (CharSequence)String.class.getTypeName())) {
            rawString = value == null ? null : (String)value;
        } else if (StringUtils.equalsAny((CharSequence)typeName, (CharSequence[])new CharSequence[]{Integer.class.getTypeName(), Long.class.getTypeName(), Float.class.getTypeName(), Double.class.getTypeName(), BigDecimal.class.getTypeName()})) {
            rawString = value == null ? null : String.valueOf(value);
        } else if (StringUtils.equalsAny((CharSequence)typeName, (CharSequence[])new CharSequence[]{"int", "long", "float", "double"})) {
            rawString = value == null ? "0" : String.valueOf(value);
        } else {
            throw new ClassCastException("Type " + typeName + " is not supported");
        }
        return rawString;
    }
}

