/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.service.helper;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class NtsJsonHelper {
    private final ObjectMapper objectMapper;

    public NtsJsonHelper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public JsonNode getJsonNode(String rawString, String rootName) throws IOException {
        JsonNode tree = this.objectMapper.readTree(rawString);
        if (StringUtils.isNotEmpty((CharSequence)rootName) && tree.has(rootName)) {
            return tree.path(rootName);
        }
        return tree;
    }

    public boolean existField(JsonNode node, String fieldName) {
        boolean found;
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            return false;
        }
        if (fieldName.contains(".")) {
            String[] fields = fieldName.split("\\.");
            JsonNode tempNode = node.path(fields[0]);
            boolean bl = found = !tempNode.isMissingNode();
            if (found && fields.length > 1) {
                for (int index = 1; found && index < fields.length; ++index) {
                    found = !(tempNode = tempNode.path(fields[index])).isMissingNode();
                }
            }
        } else {
            found = !node.path(fieldName).isMissingNode();
        }
        return found;
    }
}

