/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.web.rest.errors;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nentangso.core.service.errors.FormValidationException;
import org.nentangso.core.service.errors.NotFoundException;
import org.nentangso.core.web.rest.errors.BadRequestAlertException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.resource.BearerTokenError;
import org.springframework.security.oauth2.server.resource.authentication.AbstractOAuth2TokenAuthenticationToken;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingPathVariableException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.support.MissingServletRequestPartException;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ConditionalOnProperty(prefix="nts.web.rest.exception-translator", name={"enabled"}, havingValue="true", matchIfMissing=true)
@ControllerAdvice
@ConditionalOnMissingBean(name={"exceptionTranslator"})
public class NtsExceptionTranslator
extends ResponseEntityExceptionHandler
implements AuthenticationEntryPoint,
AccessDeniedHandler {
    private static final Logger log = LoggerFactory.getLogger(NtsExceptionTranslator.class);
    @Value(value="${nts.web.rest.exception-translator.realm-name:API Authentication by nentangso.org}")
    protected String realmName;

    @ExceptionHandler(value={ResponseStatusException.class, ConcurrencyFailureException.class, NotFoundException.class, BadRequestAlertException.class, FormValidationException.class})
    protected ResponseEntity<Object> handleNtsException(Exception ex, WebRequest request) throws Exception {
        HttpHeaders headers = new HttpHeaders();
        if (ex instanceof AuthenticationException) {
            HttpStatus status = HttpStatus.UNAUTHORIZED;
            return this.handleAuthentication((AuthenticationException)ex, headers, status, request);
        }
        if (ex instanceof AccessDeniedException) {
            HttpStatus status = HttpStatus.FORBIDDEN;
            return this.handleAccessDenied((AccessDeniedException)ex, headers, status, request);
        }
        if (ex instanceof ResponseStatusException) {
            return this.handleResponseStatus((ResponseStatusException)ex, headers, null, request);
        }
        if (ex instanceof ConcurrencyFailureException) {
            HttpStatus status = HttpStatus.CONFLICT;
            return this.handleConcurrencyFailure((ConcurrencyFailureException)ex, headers, status, request);
        }
        if (ex instanceof NotFoundException) {
            HttpStatus status = HttpStatus.NOT_FOUND;
            return this.handleNotFound((NotFoundException)ex, headers, status, request);
        }
        if (ex instanceof BadRequestAlertException) {
            HttpStatus status = HttpStatus.UNPROCESSABLE_ENTITY;
            return this.handleBadRequestAlert((BadRequestAlertException)ex, headers, status, request);
        }
        if (ex instanceof FormValidationException) {
            HttpStatus status = HttpStatus.UNPROCESSABLE_ENTITY;
            return this.handleFormValidation((FormValidationException)ex, headers, status, request);
        }
        throw ex;
    }

    private ResponseEntity<Object> handleAuthentication(AuthenticationException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        log.warn(ex.getMessage());
        headers.set("WWW-Authenticate", this.generateAuthenticateHeader((Exception)ex, headers, status, request));
        return this.handleExceptionInternal((Exception)ex, null, headers, status, request);
    }

    @Deprecated(since="1.1.5")
    protected String generateAuthenticateHeader(Exception ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        return String.format("Basic realm=\"%s\"", this.realmName);
    }

    private ResponseEntity<Object> handleAccessDenied(AccessDeniedException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        log.warn(ex.getMessage());
        headers.set("WWW-Authenticate", this.generateAuthenticateHeader((Exception)ex, headers, status, request));
        return this.handleExceptionInternal((Exception)ex, null, headers, status, request);
    }

    private ResponseEntity<Object> handleResponseStatus(ResponseStatusException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        return this.handleExceptionInternal((Exception)ex, null, headers, ex.getStatus(), request);
    }

    private ResponseEntity<Object> handleConcurrencyFailure(ConcurrencyFailureException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        log.warn(ex.getMessage());
        return this.handleExceptionInternal((Exception)ex, null, headers, status, request);
    }

    private ResponseEntity<Object> handleNotFound(NotFoundException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, request);
    }

    private ResponseEntity<Object> handleBadRequestAlert(BadRequestAlertException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, request);
    }

    private ResponseEntity<Object> handleFormValidation(FormValidationException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, request);
    }

    protected ResponseEntity<Object> handleConversionNotSupported(ConversionNotSupportedException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        return super.handleConversionNotSupported(ex, headers, HttpStatus.BAD_REQUEST, request);
    }

    protected ResponseEntity<Object> handleMissingPathVariable(MissingPathVariableException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        return super.handleMissingPathVariable(ex, headers, HttpStatus.NOT_FOUND, request);
    }

    protected ResponseEntity<Object> handleHttpRequestMethodNotSupported(HttpRequestMethodNotSupportedException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        return super.handleHttpRequestMethodNotSupported(ex, headers, HttpStatus.NOT_ACCEPTABLE, request);
    }

    protected ResponseEntity<Object> handleHttpMediaTypeNotSupported(HttpMediaTypeNotSupportedException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        return super.handleHttpMediaTypeNotSupported(ex, headers, HttpStatus.UNSUPPORTED_MEDIA_TYPE, request);
    }

    protected ResponseEntity<Object> handleServletRequestBindingException(ServletRequestBindingException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        return super.handleServletRequestBindingException(ex, headers, HttpStatus.UNPROCESSABLE_ENTITY, request);
    }

    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        return super.handleMethodArgumentNotValid(ex, headers, HttpStatus.UNPROCESSABLE_ENTITY, request);
    }

    protected ResponseEntity<Object> handleMissingServletRequestPart(MissingServletRequestPartException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        return super.handleMissingServletRequestPart(ex, headers, HttpStatus.UNPROCESSABLE_ENTITY, request);
    }

    protected ResponseEntity<Object> handleMissingServletRequestParameter(MissingServletRequestParameterException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        return super.handleMissingServletRequestParameter(ex, headers, HttpStatus.UNPROCESSABLE_ENTITY, request);
    }

    protected ResponseEntity<Object> handleBindException(BindException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        return super.handleBindException(ex, headers, HttpStatus.UNPROCESSABLE_ENTITY, request);
    }

    protected ResponseEntity<Object> handleExceptionInternal(Exception ex, @Nullable Object body, HttpHeaders headers, HttpStatus status, WebRequest request) {
        if (HttpStatus.UNAUTHORIZED.equals((Object)status) && body == null) {
            body = Collections.singletonMap("errors", "[API] Invalid API key or access token (unrecognized login or wrong password)");
        } else if (HttpStatus.FORBIDDEN.equals((Object)status) && body == null) {
            body = Collections.singletonMap("errors", "[API] This action requires merchant approval for the necessary scope.");
        } else if (HttpStatus.UNPROCESSABLE_ENTITY.equals((Object)status) && body == null) {
            Map<String, List<String>> errors = this.buildUnprocessableErrors(ex);
            body = Collections.singletonMap("errors", errors);
        } else if (status.is4xxClientError() && body == null) {
            body = Collections.singletonMap("errors", status.getReasonPhrase());
        } else if (status.is5xxServerError() && body == null) {
            String errors = (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)ex.getMessage(), (CharSequence)HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase());
            body = Collections.singletonMap("errors", errors);
        }
        return super.handleExceptionInternal(ex, body, headers, status, request);
    }

    protected Map<String, List<String>> buildUnprocessableErrors(Exception ex) {
        Map<String, List<String>> errors = Collections.singletonMap("base", Collections.singletonList("Required parameter missing or invalid"));
        if (ex instanceof FormValidationException && !((FormValidationException)ex).getErrors().isEmpty()) {
            errors = ((FormValidationException)ex).getErrors();
        } else if (ex instanceof BadRequestAlertException) {
            errors = Collections.singletonMap(((BadRequestAlertException)ex).getErrorKey(), Collections.singletonList(ex.getMessage()));
        } else if (ex instanceof BindException) {
            errors = FormValidationException.buildErrors((BindingResult)((BindException)ex).getBindingResult());
        } else if (ex instanceof MissingServletRequestParameterException) {
            errors = Collections.singletonMap(((MissingServletRequestParameterException)ex).getParameterName(), Collections.singletonList(ex.getMessage()));
        } else if (ex instanceof MissingServletRequestPartException) {
            errors = Collections.singletonMap(((MissingServletRequestPartException)ex).getRequestPartName(), Collections.singletonList(ex.getMessage()));
        }
        return errors;
    }

    @ExceptionHandler(value={Exception.class})
    protected ResponseEntity<Object> handleInternalServerError(Exception ex, WebRequest request) {
        log.error("Internal Server Error", (Throwable)ex);
        HttpHeaders headers = new HttpHeaders();
        HttpStatus status = HttpStatus.INTERNAL_SERVER_ERROR;
        return this.handleExceptionInternal(ex, null, headers, status, request);
    }

    @ExceptionHandler(value={AuthenticationException.class})
    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException {
        HttpStatus status = this.getAuthenticationStatus(authException);
        Map<String, String> parameters = this.createAuthenticationParameters(authException);
        NtsExceptionTranslator.respond(response, status, parameters, "[API] Invalid API key or access token (unrecognized login or wrong password)");
    }

    protected HttpStatus getAuthenticationStatus(AuthenticationException authException) {
        OAuth2Error error;
        if (authException instanceof OAuth2AuthenticationException && (error = ((OAuth2AuthenticationException)authException).getError()) instanceof BearerTokenError) {
            return ((BearerTokenError)error).getHttpStatus();
        }
        return HttpStatus.UNAUTHORIZED;
    }

    protected Map<String, String> createAuthenticationParameters(AuthenticationException authException) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        if (this.realmName != null) {
            parameters.put("realm", this.realmName);
        }
        if (authException instanceof OAuth2AuthenticationException) {
            BearerTokenError bearerTokenError;
            OAuth2Error error = ((OAuth2AuthenticationException)authException).getError();
            parameters.put("error", error.getErrorCode());
            if (StringUtils.hasText((String)error.getDescription())) {
                parameters.put("error_description", error.getDescription());
            }
            if (StringUtils.hasText((String)error.getUri())) {
                parameters.put("error_uri", error.getUri());
            }
            if (error instanceof BearerTokenError && StringUtils.hasText((String)(bearerTokenError = (BearerTokenError)error).getScope())) {
                parameters.put("scope", bearerTokenError.getScope());
            }
        }
        return parameters;
    }

    private static void respond(HttpServletResponse response, HttpStatus status, Map<String, String> parameters, String errors) throws IOException {
        String wwwAuthenticate = NtsExceptionTranslator.computeWWWAuthenticateHeaderValue(parameters);
        response.setStatus(status.value());
        response.addHeader("WWW-Authenticate", wwwAuthenticate);
        response.setContentType("application/json");
        String responseBody = String.format("{\"errors\":\"%s\"}", errors);
        response.getWriter().write(responseBody);
    }

    private static String computeWWWAuthenticateHeaderValue(Map<String, String> parameters) {
        StringBuilder wwwAuthenticate = new StringBuilder();
        wwwAuthenticate.append("Bearer");
        if (!parameters.isEmpty()) {
            wwwAuthenticate.append(" ");
            int i = 0;
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                wwwAuthenticate.append(entry.getKey()).append("=\"").append(entry.getValue()).append("\"");
                if (i != parameters.size() - 1) {
                    wwwAuthenticate.append(", ");
                }
                ++i;
            }
        }
        return wwwAuthenticate.toString();
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) {
        Map<String, String> parameters = this.createAccessDeniedParameters(request);
        String wwwAuthenticate = NtsExceptionTranslator.computeWWWAuthenticateHeaderValue(parameters);
        response.addHeader("WWW-Authenticate", wwwAuthenticate);
        response.setStatus(HttpStatus.FORBIDDEN.value());
    }

    private Map<String, String> createAccessDeniedParameters(HttpServletRequest request) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        if (this.realmName != null) {
            parameters.put("realm", this.realmName);
        }
        if (request.getUserPrincipal() instanceof AbstractOAuth2TokenAuthenticationToken) {
            parameters.put("error", "insufficient_scope");
            parameters.put("error_description", "The request requires higher privileges than provided by the access token.");
            parameters.put("error_uri", "https://tools.ietf.org/html/rfc6750#section-3.1");
        }
        return parameters;
    }
}

