/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.service.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.function.Supplier;
import javax.validation.constraints.NotNull;
import org.nentangso.core.service.utils.NtsValidationUtils;

@Schema(description="Represents a generic custom attribute.")
public class NtsAttributeDTO
implements Serializable {
    @NotNull
    @Schema(description="Key or name of the attribute.\n")
    private final String key;
    @Schema(description="Value of the attribute.")
    private final String value;

    private NtsAttributeDTO(Builder builder) {
        this.key = builder.key;
        this.value = builder.value;
        if (!builder.skipValidation) {
            this.validateObject(null);
        }
    }

    public void validateObject(String prefix) {
        NtsValidationUtils.validateObject(this, prefix);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(NtsAttributeDTO input) {
        return new Builder(input);
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public static final class Builder {
        private String key;
        private String value;
        private boolean skipValidation;

        private Builder() {
        }

        public Builder(NtsAttributeDTO input) {
            this.key = input.getKey();
            this.value = input.getValue();
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder keyIf(boolean condition, Supplier<String> keySupplier) {
            if (condition) {
                return this.key(keySupplier.get());
            }
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Builder valueIf(boolean condition, Supplier<String> valueSupplier) {
            if (condition) {
                return this.value(valueSupplier.get());
            }
            return this;
        }

        public Builder skipValidation(boolean skipValidation) {
            this.skipValidation = skipValidation;
            return this;
        }

        public NtsAttributeDTO build() {
            return new NtsAttributeDTO(this);
        }
    }
}

