/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.web.rest;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.nentangso.core.service.dto.NtsMetafieldDTO;
import org.nentangso.core.service.errors.NtsNotFoundException;
import org.nentangso.core.service.helper.NtsJsonHelper;
import org.nentangso.core.service.helper.NtsMetafieldHelper;
import org.nentangso.core.service.mapper.NtsMetafieldMapper;
import org.nentangso.core.web.rest.utils.NtsRequestUtils;
import org.nentangso.core.web.rest.vm.MetafieldInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

public abstract class AbstractMetafieldResource {
    private final Logger log = LoggerFactory.getLogger(AbstractMetafieldResource.class);
    private static final String ENTITY_NAME = "metafield";
    protected final NtsJsonHelper jsonHelper;
    protected final NtsMetafieldHelper metafieldHelper;
    protected final NtsMetafieldMapper metafieldMapper;

    protected AbstractMetafieldResource(NtsJsonHelper jsonHelper, NtsMetafieldHelper metafieldHelper, NtsMetafieldMapper metafieldMapper) {
        this.jsonHelper = jsonHelper;
        this.metafieldHelper = metafieldHelper;
        this.metafieldMapper = metafieldMapper;
    }

    protected abstract String getApplicationName();

    protected abstract String getOwnerResource();

    protected abstract boolean existsByOwnerId(long var1);

    protected abstract URI buildCreatedUri(long var1, long var3) throws URISyntaxException;

    protected ResponseEntity<NtsMetafieldDTO> createMetafield(long ownerId, MetafieldInput metafield) throws URISyntaxException {
        this.log.debug("REST request to save metafield : {}", (Object)metafield);
        if (!this.existsByOwnerId(ownerId)) {
            throw new NtsNotFoundException();
        }
        NtsMetafieldDTO metafieldDTO = this.metafieldMapper.toDto(metafield, this.getOwnerResource(), ownerId);
        NtsMetafieldDTO result = this.metafieldHelper.save(metafieldDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)this.buildCreatedUri(ownerId, result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.getApplicationName(), (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    protected ResponseEntity<NtsMetafieldDTO> updateMetafield(long ownerId, long id, MetafieldInput metafield, HttpServletRequest request) throws IOException {
        this.log.debug("REST request to update metafield : {}", (Object)metafield);
        if (!this.existsByOwnerId(ownerId)) {
            throw new NtsNotFoundException();
        }
        NtsMetafieldDTO.Builder builder = this.metafieldHelper.findOne(this.getOwnerResource(), ownerId, id).map(NtsMetafieldDTO::newBuilder).orElseThrow(NtsNotFoundException::new);
        String body = NtsRequestUtils.getBody((ServletRequest)request);
        JsonNode node = this.jsonHelper.getJsonNode(body, null);
        NtsMetafieldDTO metafieldDTO = builder.namespaceIf(this.jsonHelper.existField(node, "namespace"), metafield::getNamespace).keyIf(this.jsonHelper.existField(node, "key"), metafield::getKey).valueIf(this.jsonHelper.existField(node, "value"), metafield::getValue).typeIf(this.jsonHelper.existField(node, "type"), metafield::getType).descriptionIf(this.jsonHelper.existField(node, "description"), metafield::getDescription).build();
        NtsMetafieldDTO result = this.metafieldHelper.save(metafieldDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.getApplicationName(), (boolean)true, (String)ENTITY_NAME, (String)String.valueOf(id)))).body((Object)result);
    }

    protected ResponseEntity<List<NtsMetafieldDTO>> getAllMetafields(long ownerId) {
        this.log.debug("REST request to get metafields");
        if (!this.existsByOwnerId(ownerId)) {
            throw new NtsNotFoundException();
        }
        List<NtsMetafieldDTO> metafields = this.metafieldHelper.findAllByOwner(this.getOwnerResource(), ownerId);
        return ResponseEntity.ok(metafields);
    }

    protected ResponseEntity<Long> countMetafields(long ownerId) {
        this.log.debug("REST request to count metafields");
        long count = this.metafieldHelper.count(this.getOwnerResource(), ownerId);
        return ResponseEntity.ok().body((Object)count);
    }

    protected ResponseEntity<NtsMetafieldDTO> getMetafield(long ownerId, long id) {
        this.log.debug("REST request to get metafield : {}", (Object)id);
        Optional<NtsMetafieldDTO> metafieldDTO = this.metafieldHelper.findOne(this.getOwnerResource(), ownerId, id);
        return ResponseUtil.wrapOrNotFound(metafieldDTO);
    }

    protected ResponseEntity<Void> deleteMetafield(long ownerId, long id) {
        this.log.debug("REST request to delete metafield : {}", (Object)id);
        this.metafieldHelper.delete(this.getOwnerResource(), ownerId, id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.getApplicationName(), (boolean)true, (String)ENTITY_NAME, (String)String.valueOf(id))).build();
    }
}

