/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.service.helper;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.nentangso.core.domain.NtsOutboxEventEntity;
import org.nentangso.core.repository.NtsOutboxEventRepository;
import org.nentangso.core.security.NtsSecurityUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@ConditionalOnProperty(prefix="nts.helper.outbox-event", name={"enabled"}, havingValue="true")
@Service
public class NtsOutboxEventHelper {
    private final NtsOutboxEventRepository outboxEventRepository;
    private final ObjectMapper objectMapper;

    public NtsOutboxEventHelper(NtsOutboxEventRepository outboxEventRepository, ObjectMapper objectMapper) {
        this.outboxEventRepository = outboxEventRepository;
        this.objectMapper = objectMapper;
    }

    @Transactional
    public void batchQueue(String aggregateType, String eventType, List<?> payloads) throws IOException {
        if (payloads == null || payloads.isEmpty()) {
            return;
        }
        for (Object payload : payloads) {
            this.queue(aggregateType, UUID.randomUUID().toString(), eventType, payload, 0);
        }
    }

    @Transactional
    public void queue(String aggregateType, String eventType, Object payload) throws IOException {
        this.queue(aggregateType, UUID.randomUUID().toString(), eventType, payload, 0);
    }

    @Transactional
    public void queue(String aggregateType, String aggregateId, String eventType, Object payload, int aggregateVersion) throws IOException {
        String actor = NtsSecurityUtils.getCurrentUserLogin().orElse("system");
        this.queue(aggregateType, aggregateId, eventType, payload, actor, aggregateVersion, 1);
    }

    @Transactional
    public void queue(String aggregateType, String aggregateId, String eventType, Object payload, String actor, int aggregateVersion, int businessVersion) throws IOException {
        NtsOutboxEventEntity outboxEvent = new NtsOutboxEventEntity();
        String payloadJson = payload instanceof String ? (String)payload : this.objectMapper.writeValueAsString(payload);
        outboxEvent.setAggregateType(aggregateType);
        outboxEvent.setAggregateId(aggregateId);
        outboxEvent.setEventType(eventType);
        outboxEvent.setPayload(payloadJson);
        outboxEvent.setActor(actor);
        outboxEvent.setAggregateVersion(aggregateVersion);
        outboxEvent.setBusinessVersion(businessVersion);
        this.outboxEventRepository.save(outboxEvent);
    }
}

