/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.domain;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Where;
import org.nentangso.core.domain.AbstractAuditingEntity;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;

@ConditionalOnProperty(prefix="nts.helper.option", name={"enabled"}, havingValue="true")
@Entity
@Table(name="nts_options")
@Where(clause="deleted = false")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class NtsOptionEntity
extends AbstractAuditingEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    private Long id;
    @NotBlank
    @Size(max=50)
    @Column(name="option_key", length=50, nullable=false)
    @Pattern(regexp="^[a-zA-Z0-9_.-]+$")
    private @NotBlank @Size(max=50) @Pattern(regexp="^[a-zA-Z0-9_.-]+$") String optionKey;
    @Size(max=255)
    @Column(name="option_value")
    private @Size(max=255) String optionValue;
    @Column(name="deleted", nullable=false)
    private boolean deleted = false;

    public NtsOptionEntity() {
    }

    public NtsOptionEntity(String optionKey, String optionValue) {
        this.optionKey = optionKey;
        this.optionValue = optionValue;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getOptionKey() {
        return this.optionKey;
    }

    public void setOptionKey(String optionKey) {
        this.optionKey = optionKey;
    }

    public String getOptionValue() {
        return this.optionValue;
    }

    public void setOptionValue(String optionValue) {
        this.optionValue = optionValue;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NtsOptionEntity)) {
            return false;
        }
        return this.id != null && this.id.equals(((NtsOptionEntity)o).id);
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return "OptionEntity{id=" + this.id + ", optionKey='" + this.optionKey + "', optionValue='" + this.optionValue + "', deleted=" + this.deleted + ", createdBy='" + this.getCreatedBy() + "', createdAt=" + this.getCreatedAt() + ", updatedBy='" + this.getUpdatedBy() + "', updatedAt=" + this.getUpdatedAt() + "}";
    }
}

