/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.service.helper;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.validation.constraints.Min;
import org.nentangso.core.service.dto.NtsLocationDTO;
import org.nentangso.core.service.provider.NtsLocationProvider;
import org.nentangso.core.service.provider.NtsLocationProviderFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@ConditionalOnProperty(prefix="nts.helper.location", name={"enabled"}, havingValue="true")
@Service
public class NtsLocationHelper {
    private final NtsLocationProvider locationProvider;

    public NtsLocationHelper(NtsLocationProviderFactory locationProviderFactory) {
        this.locationProvider = locationProviderFactory.getLocationProvider();
    }

    private Set<Long> findAlIds() {
        return this.locationProvider.findAllIds();
    }

    public Set<NtsLocationDTO> findAll() {
        return Collections.emptySet();
    }

    public Optional<NtsLocationDTO> findById(Long id) {
        return this.locationProvider.findById(id);
    }

    public Set<Long> getGrantedLocationIds() {
        if (this.isGrantedAnyLocations()) {
            return this.findAlIds();
        }
        return Collections.emptySet();
    }

    public boolean isGrantedAnyLocations() {
        return this.locationProvider.isGrantedAnyLocations();
    }

    public boolean hasGrantedLocation(@Min(value=1L) @Min(value=1L) Integer id) {
        return this.locationProvider.hasGrantedLocation(id);
    }
}

