/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.service.helper;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.nentangso.core.domain.NtsNoteEntity;
import org.nentangso.core.repository.NtsNoteRepository;
import org.nentangso.core.service.errors.NtsNotFoundException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@ConditionalOnProperty(prefix="nts.helper.note", name={"enabled"}, havingValue="true")
@Service
public class NtsNoteHelper {
    private final NtsNoteRepository noteRepository;

    public NtsNoteHelper(NtsNoteRepository noteRepository) {
        this.noteRepository = noteRepository;
    }

    public Optional<String> findNoteById(@NotNull @Min(value=1L) @NotNull @Min(value=1L) Long id) {
        if (id == null || id <= 0L) {
            return Optional.empty();
        }
        return this.noteRepository.findById(id).map(NtsNoteEntity::getNote);
    }

    public Map<Long, String> findAllNoteById(Collection<@NotNull @Min(value=1L) Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyMap();
        }
        return this.noteRepository.findAllById(ids).stream().collect(Collectors.toMap(NtsNoteEntity::getId, NtsNoteEntity::getNote));
    }

    @Transactional
    public Optional<NtsNoteEntity> save(String note, Long id) {
        if (StringUtils.isEmpty((CharSequence)note)) {
            if (Objects.nonNull(id)) {
                this.noteRepository.deleteById(id);
            }
            return Optional.empty();
        }
        NtsNoteEntity noteEntity = new NtsNoteEntity();
        if (Objects.nonNull(id) && StringUtils.equals((CharSequence)(noteEntity = (NtsNoteEntity)this.noteRepository.findById(id).orElseThrow(NtsNotFoundException::new)).getNote(), (CharSequence)note)) {
            return Optional.of(noteEntity);
        }
        noteEntity.setNote(note);
        return Optional.of((NtsNoteEntity)this.noteRepository.save(noteEntity));
    }

    @Transactional
    public Optional<NtsNoteEntity> save(String note, NtsNoteEntity noteEntity) {
        if (StringUtils.isEmpty((CharSequence)note)) {
            if (Objects.nonNull(noteEntity) && Objects.nonNull(noteEntity.getId())) {
                this.noteRepository.deleteById(noteEntity.getId());
            }
            return Optional.empty();
        }
        if (Objects.isNull(noteEntity) || Objects.isNull(noteEntity.getId())) {
            noteEntity = new NtsNoteEntity();
        }
        if (StringUtils.equals((CharSequence)noteEntity.getNote(), (CharSequence)note)) {
            return Optional.of(noteEntity);
        }
        noteEntity.setNote(note);
        return Optional.of((NtsNoteEntity)this.noteRepository.save(noteEntity));
    }
}

