/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.web.rest.utils;

import java.io.IOException;
import java.util.Optional;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import org.springframework.web.util.ContentCachingRequestWrapper;

public class NtsRequestUtils {
    private NtsRequestUtils() {
    }

    public static String getBody(ServletRequest request) throws IOException {
        ContentCachingRequestWrapper wrappedRequest = NtsRequestUtils.getWrappedRequest(request).orElseThrow(() -> new UnsupportedOperationException("Application filters is not configure correctly."));
        byte[] bytes = wrappedRequest.getContentAsByteArray();
        return new String(bytes, wrappedRequest.getCharacterEncoding());
    }

    private static Optional<ContentCachingRequestWrapper> getWrappedRequest(ServletRequest request) {
        if (request instanceof ContentCachingRequestWrapper) {
            return Optional.of((ContentCachingRequestWrapper)request);
        }
        if (request instanceof ServletRequestWrapper) {
            return NtsRequestUtils.getWrappedRequest(((ServletRequestWrapper)request).getRequest());
        }
        return Optional.empty();
    }
}

