/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.client;

import feign.RequestInterceptor;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.context.annotation.Bean;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class NtsCookieRelayInterceptedFeignConfiguration {
    @Bean(name={"oauth2RequestInterceptor"})
    public RequestInterceptor getOAuth2RequestInterceptor() {
        return template -> {
            Optional<String> cookieHeader = this.getCookieHeader();
            cookieHeader.ifPresent(s -> template.header("Cookie", new String[]{s}));
        };
    }

    private Optional<String> getCookieHeader() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        String cookie = request.getHeader("Cookie");
        return Optional.ofNullable(cookie);
    }
}

