/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.domain;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Where;
import org.nentangso.core.domain.AbstractAuditingEntity;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;

@ConditionalOnProperty(prefix="nts.helper.metafield", name={"enabled"}, havingValue="true")
@Entity
@Table(name="nts_metafields")
@Where(clause="deleted = false")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class NtsMetafieldEntity
extends AbstractAuditingEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    private Long id;
    @NotNull
    @Size(max=20)
    @Column(name="owner_resource", length=20, nullable=false)
    private @NotNull @Size(max=20) String ownerResource;
    @NotNull
    @Min(value=1L)
    @Column(name="owner_id", nullable=false)
    private @NotNull @Min(value=1L) Long ownerId;
    @NotNull
    @Size(min=2, max=20)
    @Column(name="namespace", length=20)
    private @NotNull @Size(min=2, max=20) String namespace;
    @NotNull
    @Size(min=3, max=30)
    @Column(name="nts_key", length=30)
    private @NotNull @Size(min=3, max=30) String key;
    @Lob
    @Size(max=65535)
    @Column(name="nts_value", length=65535)
    private @Size(max=65535) String value;
    @NotNull
    @Column(name="nts_type", length=50, nullable=false)
    private String type;
    @Column(name="description")
    private String description;
    @Column(name="deleted", nullable=false)
    private boolean deleted = false;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getOwnerResource() {
        return this.ownerResource;
    }

    public void setOwnerResource(String ownerResource) {
        this.ownerResource = ownerResource;
    }

    public NtsMetafieldEntity ownerResource(String ownerResource) {
        this.setOwnerResource(ownerResource);
        return this;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public NtsMetafieldEntity ownerId(Long ownerId) {
        this.setOwnerId(ownerId);
        return this;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public NtsMetafieldEntity namespace(String namespace) {
        this.setNamespace(namespace);
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public NtsMetafieldEntity key(String key) {
        this.setKey(key);
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public NtsMetafieldEntity value(String value) {
        this.setValue(value);
        return this;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public NtsMetafieldEntity type(String type) {
        this.setType(type);
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public NtsMetafieldEntity description(String description) {
        this.setDescription(description);
        return this;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NtsMetafieldEntity)) {
            return false;
        }
        return this.id != null && this.id.equals(((NtsMetafieldEntity)o).id);
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return "MetafieldEntity{id=" + this.id + ", ownerResource='" + this.ownerResource + "', ownerId=" + this.ownerId + ", namespace='" + this.namespace + "', key='" + this.key + "', value='" + this.value + "', type='" + this.type + "', description='" + this.description + "', deleted=" + this.deleted + ", createdBy='" + this.getCreatedBy() + "', createdAt=" + this.getCreatedAt() + ", updatedBy='" + this.getUpdatedBy() + "', updatedAt=" + this.getUpdatedAt() + "}";
    }
}

