/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.service.helper;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.nentangso.core.domain.NtsTagsEntity;
import org.nentangso.core.repository.NtsTagsRepository;
import org.nentangso.core.service.errors.NtsNotFoundException;
import org.nentangso.core.service.utils.NtsTextUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@ConditionalOnProperty(prefix="nts.helper.tag", name={"enabled"}, havingValue="true")
@Component
public class NtsTagsHelper {
    private final NtsTagsRepository tagsRepository;

    public NtsTagsHelper(NtsTagsRepository tagsRepository) {
        this.tagsRepository = tagsRepository;
    }

    public Set<@NotNull String> findTagsById(@NotNull @Min(value=1L) @NotNull @Min(value=1L) Long id) {
        if (id == null || id <= 0L) {
            return Collections.emptySet();
        }
        return this.tagsRepository.findById(id).map(NtsTagsEntity::getTags).map(NtsTextUtils::splitTags).orElseGet(Collections::emptySet);
    }

    public Optional<String> findJoinedTagsById(@NotNull @Min(value=1L) @NotNull @Min(value=1L) Long id) {
        if (id == null || id <= 0L) {
            return Optional.empty();
        }
        return this.tagsRepository.findById(id).map(NtsTagsEntity::getTags);
    }

    public Map<Long, Set<String>> findAllTagsById(Collection<@NotNull @Min(value=1L) Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyMap();
        }
        return this.tagsRepository.findAllById(ids).stream().collect(Collectors.toMap(NtsTagsEntity::getId, v -> NtsTextUtils.splitTags((String)v.getTags())));
    }

    public Map<Long, String> findAllJoinedTagsById(Collection<@NotNull @Min(value=1L) Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyMap();
        }
        return this.tagsRepository.findAllById(ids).stream().collect(Collectors.toMap(NtsTagsEntity::getId, NtsTagsEntity::getTags));
    }

    @Transactional
    public Optional<NtsTagsEntity> save(Set<String> tags, Long id) {
        String joinedTags = NtsTextUtils.joinTags(tags);
        return this.save(joinedTags, id);
    }

    @Transactional
    public Optional<NtsTagsEntity> save(String joinedTags, Long id) {
        if (StringUtils.isEmpty((CharSequence)joinedTags)) {
            if (Objects.nonNull(id)) {
                this.tagsRepository.deleteById(id);
            }
            return Optional.empty();
        }
        NtsTagsEntity tagsEntity = new NtsTagsEntity();
        if (Objects.nonNull(id) && StringUtils.equals((CharSequence)(tagsEntity = (NtsTagsEntity)this.tagsRepository.findById(id).orElseThrow(NtsNotFoundException::new)).getTags(), (CharSequence)joinedTags)) {
            return Optional.of(tagsEntity);
        }
        tagsEntity.setTags(joinedTags);
        return Optional.of((NtsTagsEntity)this.tagsRepository.save(tagsEntity));
    }

    @Transactional
    public Optional<NtsTagsEntity> save(String joinedTags, NtsTagsEntity tagsEntity) {
        if (StringUtils.isEmpty((CharSequence)joinedTags)) {
            if (Objects.nonNull(tagsEntity) && Objects.nonNull(tagsEntity.getId())) {
                this.tagsRepository.deleteById(tagsEntity.getId());
            }
            return Optional.empty();
        }
        if (Objects.isNull(tagsEntity) || Objects.isNull(tagsEntity.getId())) {
            tagsEntity = new NtsTagsEntity();
        }
        if (StringUtils.equals((CharSequence)tagsEntity.getTags(), (CharSequence)joinedTags)) {
            return Optional.of(tagsEntity);
        }
        tagsEntity.setTags(joinedTags);
        return Optional.of((NtsTagsEntity)this.tagsRepository.save(tagsEntity));
    }
}

