/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.service.helper.location;

import java.util.Base64;
import java.util.BitSet;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.validation.constraints.Min;
import org.nentangso.core.security.NtsSecurityUtils;
import org.nentangso.core.service.dto.NtsLocationDTO;
import org.nentangso.core.service.helper.location.NtsLocationDeserializer;
import org.nentangso.core.service.helper.location.NtsLocationProvider;
import org.nentangso.core.service.helper.location.NtsLocationProviderFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@ConditionalOnProperty(prefix="nts.helper.location", name={"deserializer"}, havingValue="org.nentangso.core.service.helper.location.NtsBitSetLocationDeserializer")
@Service
public class NtsBitSetLocationDeserializer
implements NtsLocationDeserializer {
    public static final String DESERIALIZER_NAME = "org.nentangso.core.service.helper.location.NtsBitSetLocationDeserializer";
    private final NtsLocationProvider<? extends NtsLocationDTO> locationProvider;
    private final String bitSetClaim;

    public NtsBitSetLocationDeserializer(NtsLocationProviderFactory locationProviderFactory, @Value(value="${nts.helper.location.bitset.claim:nlb}") String bitSetClaim) {
        this.locationProvider = locationProviderFactory.getLocationProvider();
        this.bitSetClaim = bitSetClaim;
    }

    @Override
    public Set<Long> getGrantedLocationIds() {
        BitSet bitSet = this.getCurrentUserLocationBitSet();
        if (this.isGrantedAllLocations(bitSet)) {
            return this.locationProvider.findAllIds();
        }
        if (bitSet.length() <= 1) {
            return Collections.emptySet();
        }
        LinkedHashSet<Long> locationIds = new LinkedHashSet<Long>();
        for (int i = 1; i < bitSet.length(); ++i) {
            if (!bitSet.get(i)) continue;
            locationIds.add(Integer.toUnsignedLong(i));
        }
        return locationIds;
    }

    private BitSet getCurrentUserLocationBitSet() {
        return NtsSecurityUtils.getCurrentUserClaim(this.bitSetClaim).map(this::parseBitSet).orElseGet(BitSet::new);
    }

    private BitSet parseBitSet(Object input) {
        if (input instanceof String) {
            byte[] bytes = Base64.getDecoder().decode((String)input);
            return BitSet.valueOf(bytes);
        }
        return new BitSet();
    }

    @Override
    public boolean isGrantedAllLocations() {
        BitSet bitSet = this.getCurrentUserLocationBitSet();
        return this.isGrantedAllLocations(bitSet);
    }

    private boolean isGrantedAllLocations(BitSet bitSet) {
        return bitSet.length() > 0 && bitSet.get(0);
    }

    @Override
    public boolean isGrantedAnyLocations(Iterable<Long> ids) {
        BitSet bitSet = this.getCurrentUserLocationBitSet();
        return StreamSupport.stream(ids.spliterator(), false).anyMatch(id -> this.isGrantedLocation(bitSet, (Long)id));
    }

    @Override
    public boolean isGrantedAnyLocations(Long ... ids) {
        Iterable it = Stream.of(ids).collect(Collectors.toSet());
        return this.isGrantedAnyLocations(it);
    }

    @Override
    public boolean isGrantedLocation(@Min(value=1L) @Min(value=1L) Long id) {
        BitSet bitSet = this.getCurrentUserLocationBitSet();
        return this.isGrantedLocation(bitSet, id);
    }

    private boolean isGrantedLocation(BitSet bitSet, Long id) {
        if (id == null || id <= 0L) {
            return false;
        }
        return this.isGrantedAllLocations(bitSet) || id.intValue() < bitSet.length() && bitSet.get(id.intValue());
    }
}

