/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.service.helper.location;

import java.util.Map;
import javax.cache.configuration.Configuration;
import org.nentangso.core.config.NtsProperties;
import org.nentangso.core.service.dto.NtsDefaultLocationDTO;
import org.redisson.api.RBucket;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.codec.SerializationCodec;
import org.redisson.jcache.configuration.RedissonConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(prefix="nts.helper.location", name={"enabled"}, havingValue="true")
@Component
public class NtsDefaultLocationCacheable {
    private final NtsProperties ntsProperties;
    private final RedissonClient redissonClient;

    public NtsDefaultLocationCacheable(NtsProperties ntsProperties, Configuration<Object, Object> jcacheConfiguration) {
        this.ntsProperties = ntsProperties;
        this.redissonClient = ((RedissonConfiguration)jcacheConfiguration).getRedisson();
    }

    public Map<Long, NtsDefaultLocationDTO> getCacheLocations() {
        if (!this.ntsProperties.getHelper().getLocation().getCache().isEnabled()) {
            return null;
        }
        String cacheKey = this.generateCacheKey();
        RBucket bucket = this.redissonClient.getBucket(cacheKey, (Codec)new SerializationCodec());
        return (Map)bucket.get();
    }

    private String generateCacheKey() {
        return this.ntsProperties.getHelper().getLocation().getCache().getKeyPrefix() + "locations_by_id";
    }

    public void setCacheLocations(Map<Long, NtsDefaultLocationDTO> items) {
        if (!this.ntsProperties.getHelper().getLocation().getCache().isEnabled()) {
            return;
        }
        String cacheKey = this.generateCacheKey();
        RBucket bucket = this.redissonClient.getBucket(cacheKey, (Codec)new SerializationCodec());
        bucket.set(items);
    }
}

