/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="nts")
public class NtsProperties {
    private final SecurityProperties security = new SecurityProperties();
    private final HelperProperties helper = new HelperProperties();
    private final ClientProperties client = new ClientProperties();

    public SecurityProperties getSecurity() {
        return this.security;
    }

    public HelperProperties getHelper() {
        return this.helper;
    }

    public ClientProperties getClient() {
        return this.client;
    }

    public static class ClientProperties {
        private final AuthorizedProperties authorized = new AuthorizedProperties();

        public AuthorizedProperties getAuthorized() {
            return this.authorized;
        }

        public static class AuthorizedProperties {
            private String clientRegistrationId = "nts-client-authorized";

            public String getClientRegistrationId() {
                return this.clientRegistrationId;
            }

            public void setClientRegistrationId(String clientRegistrationId) {
                this.clientRegistrationId = clientRegistrationId;
            }
        }
    }

    public static class HelperProperties {
        private final LocationProperties location = new LocationProperties();

        public LocationProperties getLocation() {
            return this.location;
        }

        public static class LocationProperties {
            private boolean enabled = false;
            private String provider;
            private String deserializer;
            private final CacheProperties cache = new CacheProperties();

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }

            public String getProvider() {
                return this.provider;
            }

            public void setProvider(String provider) {
                this.provider = provider;
            }

            public String getDeserializer() {
                return this.deserializer;
            }

            public void setDeserializer(String deserializer) {
                this.deserializer = deserializer;
            }

            public CacheProperties getCache() {
                return this.cache;
            }

            public static class CacheProperties {
                private boolean enabled = true;
                private String keyPrefix = "nts:helper:location:";

                public boolean isEnabled() {
                    return this.enabled;
                }

                public void setEnabled(boolean enabled) {
                    this.enabled = enabled;
                }

                public String getKeyPrefix() {
                    return this.keyPrefix;
                }

                public void setKeyPrefix(String keyPrefix) {
                    this.keyPrefix = keyPrefix;
                }
            }
        }
    }

    public static class SecurityProperties {
        private final OAuth2Properties oauth2 = new OAuth2Properties();

        public OAuth2Properties getOauth2() {
            return this.oauth2;
        }

        public static class OAuth2Properties {
            private String rolesClaim = "roles";
            private String rolePrefix = "ROLE_";
            private boolean reverseOrderOfDisplayName = true;

            public String getRolesClaim() {
                return this.rolesClaim;
            }

            public void setRolesClaim(String rolesClaim) {
                this.rolesClaim = rolesClaim;
            }

            public String getRolePrefix() {
                return this.rolePrefix;
            }

            public void setRolePrefix(String rolePrefix) {
                this.rolePrefix = rolePrefix;
            }

            public boolean isReverseOrderOfDisplayName() {
                return this.reverseOrderOfDisplayName;
            }

            public void setReverseOrderOfDisplayName(boolean reverseOrderOfDisplayName) {
                this.reverseOrderOfDisplayName = reverseOrderOfDisplayName;
            }
        }
    }
}

