/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.domain;

import java.io.Serializable;
import java.time.Instant;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.annotation.CreatedDate;

@ConditionalOnProperty(prefix="nts.helper.outbox-event", name={"enabled"}, havingValue="true")
@Entity
@Table(name="nts_outbox_events")
public class NtsOutboxEventEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    private Long id;
    @NotNull
    @Size(max=255)
    @Column(name="aggregate_type", nullable=false)
    private @NotNull @Size(max=255) String aggregateType;
    @NotNull
    @Size(max=36)
    @Column(name="aggregate_id", length=36, nullable=false)
    private @NotNull @Size(max=36) String aggregateId;
    @NotNull
    @Size(max=255)
    @Column(name="event_type", nullable=false)
    private @NotNull @Size(max=255) String eventType;
    @Lob
    @NotNull
    @Size(max=65535)
    @Column(name="payload", length=65535, nullable=false)
    private @NotNull @Size(max=65535) String payload;
    @Column(name="aggregate_version", nullable=false)
    private int aggregateVersion = 0;
    @Column(name="business_version", nullable=false)
    private int businessVersion = 1;
    @NotNull
    @Size(max=255)
    @Column(name="actor", nullable=false)
    private @NotNull @Size(max=255) String actor;
    @NotNull
    @CreatedDate
    @Column(name="created_at", nullable=false, updatable=false)
    private Instant createdAt = Instant.now();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getAggregateType() {
        return this.aggregateType;
    }

    public void setAggregateType(String aggregateType) {
        this.aggregateType = aggregateType;
    }

    public String getAggregateId() {
        return this.aggregateId;
    }

    public void setAggregateId(String aggregateId) {
        this.aggregateId = aggregateId;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public int getAggregateVersion() {
        return this.aggregateVersion;
    }

    public void setAggregateVersion(int aggregateVersion) {
        this.aggregateVersion = aggregateVersion;
    }

    public int getBusinessVersion() {
        return this.businessVersion;
    }

    public void setBusinessVersion(int businessVersion) {
        this.businessVersion = businessVersion;
    }

    public String getActor() {
        return this.actor;
    }

    public void setActor(String actor) {
        this.actor = actor;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Instant createdDate) {
        this.createdAt = createdDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NtsOutboxEventEntity)) {
            return false;
        }
        return this.id != null && this.id.equals(((NtsOutboxEventEntity)o).id);
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return "OutboxEventEntity{id=" + this.id + ", aggregateType='" + this.aggregateType + "', aggregateId='" + this.aggregateId + "', eventType='" + this.eventType + "', payload='" + this.payload + "', aggregateVersion=" + this.aggregateVersion + ", businessVersion=" + this.businessVersion + ", actor='" + this.actor + "', createdDate=" + this.createdAt + "}";
    }
}

