/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.client;

import feign.RequestInterceptor;
import org.nentangso.core.client.NtsOAuth2ClientCredentialsRequestInterceptor;
import org.nentangso.core.config.NtsProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Profile;
import org.springframework.security.oauth2.client.AuthorizedClientServiceOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;

public class NtsAuthorizedFeignConfiguration {
    private final String clientRegistrationId;

    public NtsAuthorizedFeignConfiguration(NtsProperties ntsProperties) {
        this.clientRegistrationId = ntsProperties.getClient().getAuthorized().getClientRegistrationId();
    }

    @Bean(name={"oAuth2RequestInterceptor"})
    @Profile(value={"!testdev & !testprod"})
    public RequestInterceptor getOAuth2RequestInterceptor(OAuth2AuthorizedClientManager authorizedClientManager) {
        return new NtsOAuth2ClientCredentialsRequestInterceptor(authorizedClientManager, this.clientRegistrationId);
    }

    @Bean
    @Profile(value={"!testdev & !testprod"})
    public OAuth2AuthorizedClientManager authorizedClientManager(ClientRegistrationRepository clientRegistrationRepository, OAuth2AuthorizedClientService authorizedClientService) {
        return new AuthorizedClientServiceOAuth2AuthorizedClientManager(clientRegistrationRepository, authorizedClientService);
    }
}

