/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.client;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.nentangso.core.security.oauth2.AuthorizationHeaderUtil;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Profile;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class NtsAuthorizedUserFeignConfiguration {
    @Bean(name={"oAuth2RequestInterceptor"})
    @Profile(value={"!testdev & !testprod"})
    public RequestInterceptor getOAuth2RequestInterceptor(AuthorizationHeaderUtil authorizationHeaderUtil) {
        return template -> this.authenticationHeader(authorizationHeaderUtil, template);
    }

    private void authenticationHeader(AuthorizationHeaderUtil authorizationHeaderUtil, RequestTemplate template) {
        Optional<String> authorizationHeader = authorizationHeaderUtil.getAuthorizationHeader();
        if (authorizationHeader.isPresent()) {
            template.header("Authorization", new String[]{authorizationHeader.get()});
            return;
        }
        Optional<String> cookieHeader = this.getCookieHeader();
        cookieHeader.ifPresent(s -> template.header("Cookie", new String[]{s}));
    }

    private Optional<String> getCookieHeader() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        String cookie = request.getHeader("Cookie");
        return Optional.ofNullable(cookie);
    }
}

