/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.client;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Collection;
import java.util.Optional;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.core.AbstractOAuth2Token;

public class NtsOAuth2ClientCredentialsRequestInterceptor
implements RequestInterceptor {
    public static final Authentication ANONYMOUS_USER_AUTHENTICATION = new AnonymousAuthenticationToken("key", (Object)"anonymous", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_ANONYMOUS"}));
    private final OAuth2AuthorizedClientManager authorizedClientManager;
    private final String clientRegistrationId;

    public NtsOAuth2ClientCredentialsRequestInterceptor(OAuth2AuthorizedClientManager authorizedClientManager, String clientRegistrationId) {
        this.authorizedClientManager = authorizedClientManager;
        this.clientRegistrationId = clientRegistrationId;
    }

    public void apply(RequestTemplate template) {
        Optional<String> authorizationToken = this.getAuthenticationToken(this.clientRegistrationId);
        authorizationToken.ifPresent(s -> template.header("Authorization", new String[]{s}));
    }

    public Optional<String> getAuthenticationToken(String clientRegistrationId) {
        OAuth2AuthorizeRequest request = OAuth2AuthorizeRequest.withClientRegistrationId((String)clientRegistrationId).principal(ANONYMOUS_USER_AUTHENTICATION).build();
        OAuth2AuthorizedClient authorize = this.authorizedClientManager.authorize(request);
        return Optional.ofNullable(authorize).map(OAuth2AuthorizedClient::getAccessToken).map(AbstractOAuth2Token::getTokenValue).map(accessToken -> "Bearer " + accessToken);
    }
}

