/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.nentangso.core.domain.AbstractAuditingEntity;
import org.nentangso.core.domain.NtsAuthority;

@Entity
@Table(name="nts_users")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class NtsUserEntity
extends AbstractAuditingEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    private String id;
    @NotNull
    @Pattern(regexp="^(?>[a-zA-Z0-9!$&*+=?^_`{|}~.-]+@[a-zA-Z0-9-]+(?:\\.[a-zA-Z0-9-]+)*)|(?>[_.@A-Za-z0-9-]+)$")
    @Size(min=1, max=50)
    @Column(length=50, unique=true, nullable=false)
    private @NotNull @Pattern(regexp="^(?>[a-zA-Z0-9!$&*+=?^_`{|}~.-]+@[a-zA-Z0-9-]+(?:\\.[a-zA-Z0-9-]+)*)|(?>[_.@A-Za-z0-9-]+)$") @Size(min=1, max=50) String login;
    @Size(max=50)
    @Column(name="first_name", length=50)
    private @Size(max=50) String firstName;
    @Size(max=50)
    @Column(name="last_name", length=50)
    private @Size(max=50) String lastName;
    @Email
    @Size(min=5, max=254)
    @Column(length=254, unique=true)
    private @Email @Size(min=5, max=254) String email;
    @NotNull
    @Column(nullable=false)
    private boolean activated = false;
    @Size(min=2, max=10)
    @Column(name="lang_key", length=10)
    private @Size(min=2, max=10) String langKey;
    @Size(max=256)
    @Column(name="image_url", length=256)
    private @Size(max=256) String imageUrl;
    @JsonIgnore
    @ManyToMany
    @JoinTable(name="nts_user_authorities", joinColumns={@JoinColumn(name="user_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="authority_name", referencedColumnName="name")})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @BatchSize(size=20)
    private Set<NtsAuthority> authorities = new HashSet<NtsAuthority>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = StringUtils.lowerCase((String)login, (Locale)Locale.ENGLISH);
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void setActivated(boolean activated) {
        this.activated = activated;
    }

    public String getLangKey() {
        return this.langKey;
    }

    public void setLangKey(String langKey) {
        this.langKey = langKey;
    }

    public Set<NtsAuthority> getAuthorities() {
        return this.authorities;
    }

    public void setAuthorities(Set<NtsAuthority> authorities) {
        this.authorities = authorities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NtsUserEntity)) {
            return false;
        }
        return this.id != null && this.id.equals(((NtsUserEntity)o).id);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return "UserEntity{login='" + this.login + "', firstName='" + this.firstName + "', lastName='" + this.lastName + "', email='" + this.email + "', imageUrl='" + this.imageUrl + "', activated='" + this.activated + "', langKey='" + this.langKey + "'}";
    }
}

