/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.service.dto;

import java.io.Serializable;
import java.time.Instant;
import java.util.function.Supplier;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.nentangso.core.service.dto.AbstractAuditingDTO;
import org.nentangso.core.service.utils.NtsValidationUtils;

public class NtsMetafieldDTO
extends AbstractAuditingDTO
implements Serializable {
    private final Long id;
    @NotBlank
    @Size(max=20)
    private final @NotBlank @Size(max=20) String ownerResource;
    @NotNull
    @Min(value=1L)
    private final @NotNull @Min(value=1L) Long ownerId;
    @NotNull
    @Size(min=2, max=20)
    private final @NotNull @Size(min=2, max=20) String namespace;
    @NotNull
    @Size(min=3, max=30)
    private final @NotNull @Size(min=3, max=30) String key;
    @Size(max=65535)
    private final @Size(max=65535) String value;
    @NotBlank
    @Size(max=50)
    private final @NotBlank @Size(max=50) String type;
    @Size(max=255)
    private final @Size(max=255) String description;

    public NtsMetafieldDTO(Long id, String ownerResource, Long ownerId, String namespace, String key, String value, String type, String description) {
        this.id = id;
        this.ownerResource = ownerResource;
        this.ownerId = ownerId;
        this.namespace = namespace;
        this.key = key;
        this.value = value;
        this.type = type;
        this.description = description;
        this.validateObject(null);
    }

    public NtsMetafieldDTO(Builder builder) {
        this.id = builder.id;
        this.ownerResource = builder.ownerResource;
        this.ownerId = builder.ownerId;
        this.namespace = builder.namespace;
        this.key = builder.key;
        this.value = builder.value;
        this.type = builder.type;
        this.description = builder.description;
        this.setCreatedBy(builder.createdBy);
        this.setCreatedAt(builder.createdAt);
        this.setUpdatedBy(builder.updatedBy);
        this.setUpdatedAt(builder.updatedAt);
        if (!builder.skipValidation) {
            this.validateObject(null);
        }
    }

    public void validateObject(String prefix) {
        NtsValidationUtils.validateObject(this, prefix);
    }

    public static Builder newBuilder(NtsMetafieldDTO dto) {
        return new Builder(dto);
    }

    public Long getId() {
        return this.id;
    }

    public String getOwnerResource() {
        return this.ownerResource;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "MetafieldDTO{id=" + this.id + ", ownerResource='" + this.ownerResource + "', ownerId=" + this.ownerId + ", namespace='" + this.namespace + "', key='" + this.key + "', value='" + this.value + "', type='" + this.type + "', description='" + this.description + "'}";
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Long id;
        private String ownerResource;
        private Long ownerId;
        private String namespace;
        private String key;
        private String value;
        private String type;
        private String description;
        private String createdBy;
        private Instant createdAt;
        private String updatedBy;
        private Instant updatedAt;
        private boolean skipValidation;

        public Builder() {
        }

        public Builder(NtsMetafieldDTO dto) {
            this.id = dto.getId();
            this.ownerResource = dto.getOwnerResource();
            this.ownerId = dto.getOwnerId();
            this.namespace = dto.getNamespace();
            this.key = dto.getKey();
            this.value = dto.getValue();
            this.type = dto.getType();
            this.description = dto.getDescription();
            this.createdBy = dto.getCreatedBy();
            this.createdAt = dto.getCreatedAt();
            this.updatedBy = dto.getUpdatedBy();
            this.updatedAt = dto.getCreatedAt();
        }

        public Builder id(Long id) {
            this.id = id;
            return this;
        }

        public Builder ownerResource(String ownerResource) {
            this.ownerResource = ownerResource;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder namespaceIf(boolean condition, Supplier<String> namespaceSupplier) {
            if (condition) {
                return this.namespace(namespaceSupplier.get());
            }
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder keyIf(boolean condition, Supplier<String> keySupplier) {
            if (condition) {
                return this.key(keySupplier.get());
            }
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Builder valueIf(boolean condition, Supplier<String> valueSupplier) {
            if (condition) {
                return this.value(valueSupplier.get());
            }
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder typeIf(boolean condition, Supplier<String> typeSupplier) {
            if (condition) {
                return this.type(typeSupplier.get());
            }
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder descriptionIf(boolean condition, Supplier<String> descriptionSupplier) {
            if (condition) {
                return this.description(descriptionSupplier.get());
            }
            return this;
        }

        public Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder skipValidation(boolean skipValidation) {
            this.skipValidation = skipValidation;
            return this;
        }

        public NtsMetafieldDTO build() {
            return new NtsMetafieldDTO(this);
        }
    }
}

