/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.service.helper;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.Min;
import org.nentangso.core.service.dto.NtsLocationDTO;
import org.nentangso.core.service.helper.location.NtsLocationDeserializer;
import org.nentangso.core.service.helper.location.NtsLocationProvider;

public class NtsLocationHelper {
    private final NtsLocationProvider<? extends NtsLocationDTO> locationProvider;
    private final NtsLocationDeserializer locationDeserializer;

    public NtsLocationHelper(NtsLocationProvider<? extends NtsLocationDTO> locationProvider, NtsLocationDeserializer locationDeserializer) {
        this.locationProvider = locationProvider;
        this.locationDeserializer = locationDeserializer;
    }

    public List<? extends NtsLocationDTO> findAll() {
        return this.locationProvider.findAll().values().stream().collect(Collectors.toUnmodifiableList());
    }

    private Set<Long> findAlIds() {
        return this.locationProvider.findAllIds();
    }

    public Optional<? extends NtsLocationDTO> findById(Long id) {
        return this.locationProvider.findById(id);
    }

    public Set<Long> getGrantedLocationIds() {
        return this.locationDeserializer.getGrantedLocationIds();
    }

    public boolean isGrantedAllLocations() {
        return this.locationDeserializer.isGrantedAllLocations();
    }

    public boolean isGrantedAnyLocations(Iterable<Long> ids) {
        return this.locationDeserializer.isGrantedAnyLocations(ids);
    }

    public boolean isGrantedAnyLocations(Long ... ids) {
        return this.locationDeserializer.isGrantedAnyLocations(ids);
    }

    public boolean isGrantedLocation(@Min(value=1L) @Min(value=1L) Long id) {
        return this.locationDeserializer.isGrantedLocation(id);
    }
}

