/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.client;

import java.util.List;
import org.nentangso.core.client.NtsKeycloakFeignConfiguration;
import org.nentangso.core.client.vm.KeycloakClientRole;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@ConditionalOnProperty(prefix="nts.helper.location", name={"provider"}, havingValue="org.nentangso.core.service.helper.location.NtsKeycloakLocationProvider")
@FeignClient(name="nts-helper-location-keycloak", configuration={NtsKeycloakFeignConfiguration.class}, url="${nts.helper.location.keycloak.admin-base-url:http://localhost:8080/admin/realms/master}")
public interface NtsKeycloakClient {
    @GetMapping(value={"/clients/{clientId}/roles"})
    public ResponseEntity<List<KeycloakClientRole>> findClientRoles(@PathVariable(value="clientId") String var1, @RequestParam(value="briefRepresentation") Boolean var2);

    @GetMapping(value={"/clients/{clientId}/roles/{roleName}"})
    public ResponseEntity<KeycloakClientRole> findClientRole(@PathVariable(value="clientId") String var1, @PathVariable(value="roleName") String var2);

    @PostMapping(value={"/clients/{clientId}/roles"})
    public ResponseEntity<Void> createClientRole(@PathVariable(value="clientId") String var1, @RequestBody KeycloakClientRole var2);

    @PutMapping(value={"/clients/{clientId}/roles/{roleName}"})
    public ResponseEntity<Void> updateClientRole(@PathVariable(value="clientId") String var1, @PathVariable(value="roleName") String var2, @RequestBody KeycloakClientRole var3);
}

