/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.config;

import org.nentangso.core.client.NtsHelperLocationRestClient;
import org.nentangso.core.client.NtsKeycloakClient;
import org.nentangso.core.config.NtsKeycloakLocationProperties;
import org.nentangso.core.config.NtsProperties;
import org.nentangso.core.service.dto.NtsLocationDTO;
import org.nentangso.core.service.helper.NtsLocationHelper;
import org.nentangso.core.service.helper.location.NtsBitSetLocationDeserializer;
import org.nentangso.core.service.helper.location.NtsDefaultLocationCacheable;
import org.nentangso.core.service.helper.location.NtsDefaultLocationHelper;
import org.nentangso.core.service.helper.location.NtsKeycloakLocationProvider;
import org.nentangso.core.service.helper.location.NtsLocationDeserializer;
import org.nentangso.core.service.helper.location.NtsLocationProvider;
import org.nentangso.core.service.helper.location.NtsRestLocationProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnProperty(prefix="nts.helper.location", name={"enabled"}, havingValue="true")
@Configuration
public class NtsLocationHelperAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public NtsDefaultLocationCacheable ntsDefaultLocationCacheable(NtsProperties ntsProperties, javax.cache.configuration.Configuration<Object, Object> jcacheConfiguration) {
        return new NtsDefaultLocationCacheable(ntsProperties, jcacheConfiguration);
    }

    @Bean
    @ConditionalOnProperty(prefix="nts.helper.location", name={"provider"}, havingValue="org.nentangso.core.service.helper.location.NtsRestLocationProvider")
    public NtsRestLocationProvider ntsRestLocationProvider(NtsDefaultLocationCacheable locationCacheable, NtsHelperLocationRestClient restClient) {
        return new NtsRestLocationProvider(locationCacheable, restClient);
    }

    @Bean
    @ConditionalOnProperty(prefix="nts.helper.location", name={"provider"}, havingValue="org.nentangso.core.service.helper.location.NtsKeycloakLocationProvider")
    public NtsKeycloakLocationProvider ntsKeycloakLocationProvider(NtsKeycloakLocationProperties keycloakLocationProperties, NtsDefaultLocationCacheable locationCacheable, NtsKeycloakClient keycloakClient) {
        return new NtsKeycloakLocationProvider(keycloakLocationProperties, locationCacheable, keycloakClient);
    }

    @Bean
    @ConditionalOnMissingBean
    public NtsLocationProvider<? extends NtsLocationDTO> ntsLocationProvider(NtsProperties ntsProperties, ApplicationContext applicationContext) {
        String provider = ntsProperties.getHelper().getLocation().getProvider();
        try {
            Class clazz = provider != null ? Class.forName(provider) : NtsRestLocationProvider.class;
            return (NtsLocationProvider)applicationContext.getBean(clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Configuration property nts.helper.location.provider class %s can not be loaded.", provider));
        }
    }

    @Bean
    @ConditionalOnProperty(prefix="nts.helper.location", name={"deserializer"}, havingValue="org.nentangso.core.service.helper.location.NtsBitSetLocationDeserializer")
    public NtsBitSetLocationDeserializer ntsBitSetLocationDeserializer(NtsLocationProvider<? extends NtsLocationDTO> locationProvider, @Value(value="${nts.helper.location.bitset.claim:nlb}") String bitSetClaim) {
        return new NtsBitSetLocationDeserializer(locationProvider, bitSetClaim);
    }

    @Bean
    @ConditionalOnMissingBean
    public NtsLocationDeserializer ntsLocationDeserializer(NtsProperties ntsProperties, ApplicationContext applicationContext) {
        String deserializer = ntsProperties.getHelper().getLocation().getDeserializer();
        try {
            Class clazz = deserializer != null ? Class.forName(deserializer) : NtsBitSetLocationDeserializer.class;
            return (NtsLocationDeserializer)applicationContext.getBean(clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Configuration property nts.helper.location.deserializer class %s can not be loaded.", deserializer));
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public NtsLocationHelper ntsLocationHelper(NtsLocationProvider<? extends NtsLocationDTO> locationProvider, NtsLocationDeserializer locationDeserializer) {
        return new NtsDefaultLocationHelper(locationProvider, locationDeserializer);
    }
}

