/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.nentangso.core.config.NtsProperties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.stereotype.Component;

@Component
public final class NtsSecurityUtils
implements InitializingBean {
    private final String rolesClaim;
    private final String rolePrefix;
    private final boolean reverseOrderOfDisplayName;
    private static NtsSecurityUtils instance;

    @Autowired
    public NtsSecurityUtils(NtsProperties ntsProperties) {
        this.rolesClaim = ntsProperties.getSecurity().getOauth2().getRolesClaim();
        this.rolePrefix = ntsProperties.getSecurity().getOauth2().getRolePrefix();
        this.reverseOrderOfDisplayName = ntsProperties.getSecurity().getOauth2().isReverseOrderOfDisplayName();
    }

    public NtsSecurityUtils(String rolesClaim, String rolePrefix, boolean reverseOrderOfDisplayName) {
        this.rolesClaim = rolesClaim;
        this.rolePrefix = rolePrefix;
        this.reverseOrderOfDisplayName = reverseOrderOfDisplayName;
    }

    public static Optional<String> getCurrentUserLogin() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        return Optional.ofNullable(NtsSecurityUtils.extractPrincipal(securityContext.getAuthentication()));
    }

    private static String extractPrincipal(Authentication authentication) {
        if (authentication == null) {
            return null;
        }
        if (authentication.getPrincipal() instanceof UserDetails) {
            UserDetails springSecurityUser = (UserDetails)authentication.getPrincipal();
            return springSecurityUser.getUsername();
        }
        if (authentication instanceof JwtAuthenticationToken) {
            return (String)((Jwt)((JwtAuthenticationToken)authentication).getToken()).getClaims().get("preferred_username");
        }
        if (authentication.getPrincipal() instanceof DefaultOidcUser) {
            Map attributes = ((DefaultOidcUser)authentication.getPrincipal()).getAttributes();
            if (attributes.containsKey("preferred_username")) {
                return (String)attributes.get("preferred_username");
            }
        } else if (authentication.getPrincipal() instanceof String) {
            return (String)authentication.getPrincipal();
        }
        return null;
    }

    public static Optional<String> getCurrentUserDisplayName() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        return Optional.ofNullable(NtsSecurityUtils.extractDisplayName(securityContext.getAuthentication()));
    }

    private static String extractDisplayName(Authentication authentication) {
        String firstName = null;
        String lastName = null;
        if (authentication == null) {
            return null;
        }
        if (authentication.getPrincipal() instanceof UserDetails) {
            UserDetails springSecurityUser = (UserDetails)authentication.getPrincipal();
            firstName = springSecurityUser.getUsername();
        } else if (authentication instanceof JwtAuthenticationToken) {
            firstName = (String)((Jwt)((JwtAuthenticationToken)authentication).getToken()).getClaims().get("given_name");
            lastName = (String)((Jwt)((JwtAuthenticationToken)authentication).getToken()).getClaims().get("family_name");
        } else if (authentication.getPrincipal() instanceof DefaultOidcUser) {
            Map attributes = ((DefaultOidcUser)authentication.getPrincipal()).getAttributes();
            if (attributes.containsKey("given_name")) {
                firstName = (String)attributes.get("given_name");
            }
            if (attributes.containsKey("family_name")) {
                lastName = (String)attributes.get("family_name");
            }
        } else if (authentication.getPrincipal() instanceof String) {
            firstName = (String)authentication.getPrincipal();
        }
        return NtsSecurityUtils.toDisplayName(firstName, lastName);
    }

    public static String toDisplayName(String firstName, String lastName) {
        List<String> names = Arrays.asList(firstName, lastName);
        if (NtsSecurityUtils.instance.reverseOrderOfDisplayName) {
            Collections.reverse(names);
        }
        String displayName = names.stream().map(StringUtils::trimToNull).filter(Objects::nonNull).collect(Collectors.joining(" "));
        return StringUtils.trimToNull((String)displayName);
    }

    public static boolean isAuthenticated() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication != null && NtsSecurityUtils.getAuthorities(authentication).noneMatch("ROLE_ANONYMOUS"::equals);
    }

    public static boolean hasCurrentUserAnyOfAuthorities(String ... authorities) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication != null && NtsSecurityUtils.getAuthorities(authentication).anyMatch(authority -> Arrays.asList(authorities).contains(authority));
    }

    public static boolean hasCurrentUserNoneOfAuthorities(String ... authorities) {
        return !NtsSecurityUtils.hasCurrentUserAnyOfAuthorities(authorities);
    }

    public static boolean hasCurrentUserThisAuthority(String authority) {
        return NtsSecurityUtils.hasCurrentUserAnyOfAuthorities(authority);
    }

    private static Stream<String> getAuthorities(Authentication authentication) {
        List<GrantedAuthority> authorities = authentication instanceof JwtAuthenticationToken ? NtsSecurityUtils.extractAuthorityFromClaims(((Jwt)((JwtAuthenticationToken)authentication).getToken()).getClaims()) : authentication.getAuthorities();
        return authorities.stream().map(GrantedAuthority::getAuthority);
    }

    public static List<GrantedAuthority> extractAuthorityFromClaims(Map<String, Object> claims) {
        return NtsSecurityUtils.mapRolesToGrantedAuthorities(NtsSecurityUtils.getRolesFromClaims(claims));
    }

    private static Collection<String> getRolesFromClaims(Map<String, Object> claims) {
        return claims.getOrDefault(NtsSecurityUtils.instance.rolesClaim, new ArrayList());
    }

    private static List<GrantedAuthority> mapRolesToGrantedAuthorities(Collection<String> roles) {
        return roles.stream().filter(role -> role.startsWith(NtsSecurityUtils.instance.rolePrefix)).map(SimpleGrantedAuthority::new).collect(Collectors.toList());
    }

    public static Optional<Object> getCurrentUserClaim(String claim) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return NtsSecurityUtils.extractClaim(authentication, claim);
    }

    private static Optional<Object> extractClaim(Authentication authentication, String claim) {
        if (authentication == null) {
            return Optional.empty();
        }
        if (authentication.getPrincipal() instanceof UserDetails) {
            UserDetails springSecurityUser = (UserDetails)authentication.getPrincipal();
            return Optional.empty();
        }
        if (authentication instanceof JwtAuthenticationToken) {
            Object value = ((Jwt)((JwtAuthenticationToken)authentication).getToken()).getClaims().get(claim);
            return Optional.ofNullable(value);
        }
        if (authentication.getPrincipal() instanceof DefaultOidcUser) {
            Map attributes = ((DefaultOidcUser)authentication.getPrincipal()).getAttributes();
            if (attributes.containsKey(claim)) {
                Object value = attributes.get(claim);
                return Optional.ofNullable(value);
            }
        } else if (authentication.getPrincipal() instanceof String) {
            return Optional.empty();
        }
        return Optional.empty();
    }

    public void afterPropertiesSet() {
        instance = this;
    }
}

