/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.service;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.nentangso.core.domain.NtsAuthority;
import org.nentangso.core.domain.NtsUserEntity;
import org.nentangso.core.repository.NtsAuthorityRepository;
import org.nentangso.core.repository.NtsUserRepository;
import org.nentangso.core.security.NtsSecurityUtils;
import org.nentangso.core.service.dto.NtsAdminUserDTO;
import org.nentangso.core.service.dto.NtsUserDTO;
import org.nentangso.core.service.mapper.NtsUserMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cache.CacheManager;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@ConditionalOnMissingBean(name={"userService"})
public class NtsUserService {
    private final Logger log = LoggerFactory.getLogger(NtsUserService.class);
    protected final NtsUserRepository userRepository;
    protected final NtsAuthorityRepository authorityRepository;
    protected final NtsUserMapper userMapper;
    protected final CacheManager cacheManager;

    public NtsUserService(NtsUserRepository userRepository, NtsAuthorityRepository authorityRepository, NtsUserMapper userMapper, CacheManager cacheManager) {
        this.userRepository = userRepository;
        this.authorityRepository = authorityRepository;
        this.userMapper = userMapper;
        this.cacheManager = cacheManager;
    }

    public void updateUser(String firstName, String lastName, String email, String langKey, String imageUrl) {
        NtsSecurityUtils.getCurrentUserLogin().flatMap(this.userRepository::findOneByLogin).ifPresent(user -> {
            user.setFirstName(firstName);
            user.setLastName(lastName);
            if (email != null) {
                user.setEmail(email.toLowerCase());
            }
            user.setLangKey(langKey);
            user.setImageUrl(imageUrl);
            this.clearUserCaches((NtsUserEntity)user);
            this.log.debug("Changed Information for User: {}", user);
        });
    }

    @Transactional(readOnly=true)
    public Page<NtsAdminUserDTO> getAllManagedUsers(Pageable pageable) {
        return this.userRepository.findAll(pageable).map(this.userMapper::userToAdminUserDTO);
    }

    @Transactional(readOnly=true)
    public Page<NtsUserDTO> getAllPublicUsers(Pageable pageable) {
        return this.userRepository.findAllByIdNotNullAndActivatedIsTrue(pageable).map(this.userMapper::userToUserDTO);
    }

    @Transactional(readOnly=true)
    public Optional<NtsUserEntity> getUserWithAuthoritiesByLogin(String login) {
        return this.userRepository.findOneWithAuthoritiesByLogin(login);
    }

    @Transactional(readOnly=true)
    public List<String> getAuthorities() {
        return this.authorityRepository.findAll().stream().map(NtsAuthority::getName).collect(Collectors.toList());
    }

    protected NtsUserEntity syncUserWithIdP(Map<String, Object> details, NtsUserEntity user) {
        List<String> dbAuthorities = this.getAuthorities();
        Collection userAuthorities = user.getAuthorities().stream().map(NtsAuthority::getName).collect(Collectors.toList());
        for (String authority : userAuthorities) {
            if (dbAuthorities.contains(authority)) continue;
            this.log.debug("Saving authority '{}' in local database", (Object)authority);
            NtsAuthority authorityToSave = new NtsAuthority();
            authorityToSave.setName(authority);
            this.authorityRepository.save(authorityToSave);
        }
        Optional<NtsUserEntity> existingUser = this.userRepository.findOneByLogin(user.getLogin());
        if (existingUser.isPresent()) {
            if (details.get("updated_at") != null) {
                Instant dbModifiedDate = existingUser.get().getUpdatedAt();
                Instant idpModifiedDate = details.get("updated_at") instanceof Instant ? (Instant)details.get("updated_at") : Instant.ofEpochSecond(((Integer)details.get("updated_at")).intValue());
                if (idpModifiedDate.isAfter(dbModifiedDate)) {
                    this.log.debug("Updating user '{}' in local database", (Object)user.getLogin());
                    this.updateUser(user.getFirstName(), user.getLastName(), user.getEmail(), user.getLangKey(), user.getImageUrl());
                }
            } else {
                this.log.debug("Updating user '{}' in local database", (Object)user.getLogin());
                this.updateUser(user.getFirstName(), user.getLastName(), user.getEmail(), user.getLangKey(), user.getImageUrl());
            }
        } else {
            this.log.debug("Saving user '{}' in local database", (Object)user.getLogin());
            this.userRepository.save(user);
            this.clearUserCaches(user);
        }
        return user;
    }

    @Transactional
    public NtsAdminUserDTO getUserFromAuthentication(AbstractAuthenticationToken authToken) {
        Map attributes;
        if (authToken instanceof OAuth2AuthenticationToken) {
            attributes = ((OAuth2AuthenticationToken)authToken).getPrincipal().getAttributes();
        } else if (authToken instanceof JwtAuthenticationToken) {
            attributes = ((JwtAuthenticationToken)authToken).getTokenAttributes();
        } else {
            throw new IllegalArgumentException("AuthenticationToken is not OAuth2 or JWT!");
        }
        NtsUserEntity user = this.getUser(attributes);
        user.setAuthorities(authToken.getAuthorities().stream().map(GrantedAuthority::getAuthority).map(authority -> {
            NtsAuthority auth = new NtsAuthority();
            auth.setName((String)authority);
            return auth;
        }).collect(Collectors.toSet()));
        return this.userMapper.userToAdminUserDTO(this.syncUserWithIdP(attributes, user));
    }

    protected NtsUserEntity getUser(Map<String, Object> details) {
        NtsUserEntity user = new NtsUserEntity();
        Boolean activated = Boolean.TRUE;
        if (details.get("uid") != null) {
            user.setId((String)details.get("uid"));
            user.setLogin((String)details.get("sub"));
        } else {
            user.setId((String)details.get("sub"));
        }
        if (details.get("preferred_username") != null) {
            user.setLogin(((String)details.get("preferred_username")).toLowerCase());
        } else if (user.getLogin() == null) {
            user.setLogin(user.getId());
        }
        if (details.get("given_name") != null) {
            user.setFirstName((String)details.get("given_name"));
        } else if (details.get("name") != null) {
            user.setFirstName((String)details.get("name"));
        }
        if (details.get("family_name") != null) {
            user.setLastName((String)details.get("family_name"));
        }
        if (details.get("email_verified") != null) {
            activated = (Boolean)details.get("email_verified");
        }
        if (details.get("email") != null) {
            user.setEmail(((String)details.get("email")).toLowerCase());
        } else {
            user.setEmail((String)details.get("sub"));
        }
        if (details.get("langKey") != null) {
            user.setLangKey((String)details.get("langKey"));
        } else if (details.get("locale") != null) {
            String locale = (String)details.get("locale");
            if (locale.contains("_")) {
                locale = locale.substring(0, locale.indexOf(95));
            } else if (locale.contains("-")) {
                locale = locale.substring(0, locale.indexOf(45));
            }
            user.setLangKey(locale.toLowerCase());
        } else {
            user.setLangKey("en");
        }
        if (details.get("picture") != null) {
            user.setImageUrl((String)details.get("picture"));
        }
        user.setActivated(activated);
        return user;
    }

    protected void clearUserCaches(NtsUserEntity user) {
        Objects.requireNonNull(this.cacheManager.getCache("usersByLogin")).evict((Object)user.getLogin());
        if (user.getEmail() != null) {
            Objects.requireNonNull(this.cacheManager.getCache("usersByEmail")).evict((Object)user.getEmail());
        }
    }
}

