/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.service.helper.location;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.Min;
import org.nentangso.core.service.dto.NtsLocationDTO;
import org.nentangso.core.service.helper.NtsLocationHelper;
import org.nentangso.core.service.helper.location.NtsLocationDeserializer;
import org.nentangso.core.service.helper.location.NtsLocationProvider;

public class NtsDefaultLocationHelper
implements NtsLocationHelper {
    private final NtsLocationProvider<? extends NtsLocationDTO> locationProvider;
    private final NtsLocationDeserializer locationDeserializer;

    public NtsDefaultLocationHelper(NtsLocationProvider<? extends NtsLocationDTO> locationProvider, NtsLocationDeserializer locationDeserializer) {
        this.locationProvider = locationProvider;
        this.locationDeserializer = locationDeserializer;
    }

    @Override
    public List<? extends NtsLocationDTO> findAll() {
        return this.locationProvider.findAll().values().stream().collect(Collectors.toUnmodifiableList());
    }

    @Override
    public Set<Long> findAlIds() {
        return this.locationProvider.findAllIds();
    }

    @Override
    public Optional<? extends NtsLocationDTO> findById(Long id) {
        return this.locationProvider.findById(id);
    }

    @Override
    public Set<Long> getGrantedLocationIds() {
        return this.locationDeserializer.getGrantedLocationIds();
    }

    @Override
    public boolean isGrantedAllLocations() {
        return this.locationDeserializer.isGrantedAllLocations();
    }

    @Override
    public boolean isGrantedAnyLocations(Iterable<Long> ids) {
        return this.locationDeserializer.isGrantedAnyLocations(ids);
    }

    @Override
    public boolean isGrantedAnyLocations(Long ... ids) {
        return this.locationDeserializer.isGrantedAnyLocations(ids);
    }

    @Override
    public boolean isGrantedLocation(@Min(value=1L) @Min(value=1L) Long id) {
        return this.locationDeserializer.isGrantedLocation(id);
    }
}

