/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.web.rest.errors;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.nentangso.core.service.errors.FormValidateException;
import org.nentangso.core.service.errors.NotFoundException;
import org.nentangso.core.web.rest.errors.BadRequestAlertException;
import org.nentangso.core.web.rest.errors.NtsErrorConstants;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.core.env.Environment;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.DataAccessException;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.support.WebExchangeBindException;
import org.springframework.web.server.ServerWebExchange;
import org.zalando.problem.DefaultProblem;
import org.zalando.problem.Problem;
import org.zalando.problem.ProblemBuilder;
import org.zalando.problem.Status;
import org.zalando.problem.StatusType;
import org.zalando.problem.ThrowableProblem;
import org.zalando.problem.spring.webflux.advice.ProblemHandling;
import org.zalando.problem.spring.webflux.advice.security.SecurityAdviceTrait;
import org.zalando.problem.violations.ConstraintViolationProblem;
import reactor.core.publisher.Mono;
import tech.jhipster.web.util.HeaderUtil;

@ControllerAdvice
@ConditionalOnMissingBean(name={"exceptionTranslator"})
public class NtsExceptionTranslator
implements ProblemHandling,
SecurityAdviceTrait {
    private static final String ERRORS_KEY = "errors";
    private static final String MESSAGE_KEY = "message";
    private static final String PATH_KEY = "path";
    private static final String VIOLATIONS_KEY = "violations";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final Environment env;

    public NtsExceptionTranslator(Environment env) {
        this.env = env;
    }

    public Mono<ResponseEntity<Problem>> process(@Nullable ResponseEntity<Problem> entity, ServerWebExchange request) {
        if (entity == null) {
            return Mono.empty();
        }
        Problem problem = (Problem)entity.getBody();
        if (!(problem instanceof ConstraintViolationProblem) && !(problem instanceof DefaultProblem)) {
            return Mono.just(entity);
        }
        ProblemBuilder builder = Problem.builder().withType(Problem.DEFAULT_TYPE.equals(problem.getType()) ? NtsErrorConstants.DEFAULT_TYPE : problem.getType()).withStatus(problem.getStatus()).withTitle(problem.getTitle()).with(PATH_KEY, (Object)request.getRequest().getPath().value());
        if (problem instanceof ConstraintViolationProblem) {
            builder.with(VIOLATIONS_KEY, (Object)((ConstraintViolationProblem)problem).getViolations()).with(MESSAGE_KEY, (Object)"error.validation");
        } else {
            builder.withCause(((DefaultProblem)problem).getCause()).withDetail(problem.getDetail()).withInstance(problem.getInstance());
            problem.getParameters().forEach((arg_0, arg_1) -> ((ProblemBuilder)builder).with(arg_0, arg_1));
            if (!problem.getParameters().containsKey(MESSAGE_KEY) && problem.getStatus() != null) {
                builder.with(MESSAGE_KEY, (Object)("error.http." + problem.getStatus().getStatusCode()));
            }
        }
        return Mono.just((Object)new ResponseEntity((Object)builder.build(), (MultiValueMap)entity.getHeaders(), entity.getStatusCode()));
    }

    public Mono<ResponseEntity<Problem>> handleBindingResult(WebExchangeBindException ex, @Nonnull ServerWebExchange request) {
        Map fieldErrors = FormValidateException.buildFieldErrors((BindingResult)ex.getBindingResult());
        Problem problem = this.createProblemFromFieldErrors(fieldErrors);
        return this.create((Throwable)ex, problem, request);
    }

    private Problem createProblemFromFieldErrors(Map<String, List<String>> fieldErrors) {
        return Problem.builder().withType(NtsErrorConstants.CONSTRAINT_VIOLATION_TYPE).withTitle("Method argument not valid").withStatus(this.defaultConstraintViolationStatus()).with(MESSAGE_KEY, (Object)"error.validation").with(ERRORS_KEY, fieldErrors).build();
    }

    @ExceptionHandler
    public Mono<ResponseEntity<Problem>> handleBadRequestAlertException(BadRequestAlertException ex, ServerWebExchange request) {
        return this.create((ThrowableProblem)ex, request, HeaderUtil.createFailureAlert((String)this.applicationName, (boolean)true, (String)ex.getEntityName(), (String)ex.getErrorKey(), (String)ex.getMessage()));
    }

    @ExceptionHandler
    public Mono<ResponseEntity<Problem>> handleConcurrencyFailure(ConcurrencyFailureException ex, ServerWebExchange request) {
        ThrowableProblem problem = Problem.builder().withStatus((StatusType)Status.CONFLICT).with(MESSAGE_KEY, (Object)"error.concurrencyFailure").build();
        return this.create((Throwable)ex, (Problem)problem, request);
    }

    public ProblemBuilder prepare(Throwable throwable, StatusType status, URI type) {
        List<String> activeProfiles = Arrays.asList(this.env.getActiveProfiles());
        if (activeProfiles.contains("prod")) {
            if (throwable instanceof HttpMessageConversionException) {
                return Problem.builder().withType(type).withTitle(status.getReasonPhrase()).withStatus(status).withDetail("Unable to convert http message").withCause((ThrowableProblem)Optional.ofNullable(throwable.getCause()).filter(cause -> this.isCausalChainsEnabled()).map(arg_0 -> ((NtsExceptionTranslator)this).toProblem(arg_0)).orElse(null));
            }
            if (throwable instanceof DataAccessException) {
                return Problem.builder().withType(type).withTitle(status.getReasonPhrase()).withStatus(status).withDetail("Failure during data access").withCause((ThrowableProblem)Optional.ofNullable(throwable.getCause()).filter(cause -> this.isCausalChainsEnabled()).map(arg_0 -> ((NtsExceptionTranslator)this).toProblem(arg_0)).orElse(null));
            }
            if (this.containsPackageName(throwable.getMessage())) {
                return Problem.builder().withType(type).withTitle(status.getReasonPhrase()).withStatus(status).withDetail("Unexpected runtime exception").withCause((ThrowableProblem)Optional.ofNullable(throwable.getCause()).filter(cause -> this.isCausalChainsEnabled()).map(arg_0 -> ((NtsExceptionTranslator)this).toProblem(arg_0)).orElse(null));
            }
        }
        return Problem.builder().withType(type).withTitle(status.getReasonPhrase()).withStatus(status).withDetail(throwable.getMessage()).withCause((ThrowableProblem)Optional.ofNullable(throwable.getCause()).filter(cause -> this.isCausalChainsEnabled()).map(arg_0 -> ((NtsExceptionTranslator)this).toProblem(arg_0)).orElse(null));
    }

    private boolean containsPackageName(String message) {
        return StringUtils.containsAny((CharSequence)message, (CharSequence[])new CharSequence[]{"org.", "java.", "net.", "javax.", "com.", "io.", "de.", "org.nentangso.core"});
    }

    @ExceptionHandler
    public Mono<ResponseEntity<Problem>> handleFormValidateException(FormValidateException ex, ServerWebExchange request) {
        Problem problem = this.createProblemFromFieldErrors(ex.getFieldErrors());
        return this.create((Throwable)ex, problem, request);
    }

    @ExceptionHandler
    public Mono<ResponseEntity<Problem>> handleNotFoundException(NotFoundException ex, ServerWebExchange request) {
        ThrowableProblem problem = Problem.builder().withType(NtsErrorConstants.DEFAULT_TYPE).withTitle("Not Found").withStatus((StatusType)Status.NOT_FOUND).withDetail("404 NOT_FOUND").with(MESSAGE_KEY, (Object)"error.http.404").with(ERRORS_KEY, Collections.singletonMap("base", Collections.singletonList("Not Found"))).build();
        return this.create((Throwable)ex, (Problem)problem, request);
    }
}

