/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.config;

import java.time.Duration;
import java.util.Locale;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.i18n.SimpleLocaleContext;
import org.springframework.context.i18n.TimeZoneAwareLocaleContext;
import org.springframework.http.HttpCookie;
import org.springframework.http.ResponseCookie;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.i18n.LocaleContextResolver;

@Configuration
@ConditionalOnMissingBean(name={"localeConfiguration"})
public class NtsLocaleConfiguration {
    @Bean(name={"localeContextResolver"})
    public LocaleContextResolver localeContextResolver() {
        return new AngularCookieLocaleContextResolver();
    }

    @Bean
    public WebFilter localeChangeFilter(LocaleContextResolver localeContextResolver) {
        return (exchange, chain) -> {
            String newLocale = (String)exchange.getRequest().getQueryParams().getFirst((Object)"language");
            if (newLocale != null) {
                localeContextResolver.setLocaleContext(exchange, (LocaleContext)new SimpleLocaleContext(StringUtils.parseLocaleString((String)newLocale)));
            }
            return chain.filter(exchange);
        };
    }

    static class AngularCookieLocaleContextResolver
    implements LocaleContextResolver {
        private static final String LOCALE_REQUEST_ATTRIBUTE_NAME = AngularCookieLocaleContextResolver.class.getName() + ".LOCALE";
        private static final String TIME_ZONE_REQUEST_ATTRIBUTE_NAME = AngularCookieLocaleContextResolver.class.getName() + ".TIME_ZONE";
        private static final String QUOTE = "%22";
        private static final String COOKIE_NAME = "NG_TRANSLATE_LANG_KEY";
        private static final String COOKIE_PATH = "/";
        protected final Log logger = LogFactory.getLog(this.getClass());

        AngularCookieLocaleContextResolver() {
        }

        @Nonnull
        public LocaleContext resolveLocaleContext(final @Nonnull ServerWebExchange exchange) {
            this.parseLocaleCookieIfNecessary(exchange);
            return new TimeZoneAwareLocaleContext(){

                public Locale getLocale() {
                    return (Locale)exchange.getAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME);
                }

                public TimeZone getTimeZone() {
                    return (TimeZone)exchange.getAttribute(TIME_ZONE_REQUEST_ATTRIBUTE_NAME);
                }
            };
        }

        public void setLocaleContext(@Nonnull ServerWebExchange exchange, LocaleContext localeContext) {
            Assert.notNull((Object)exchange.getResponse(), (String)"ServerHttpResponse is required for AngularCookieLocaleContextResolver");
            Locale locale = null;
            TimeZone timeZone = null;
            if (localeContext != null) {
                locale = localeContext.getLocale();
                if (localeContext instanceof TimeZoneAwareLocaleContext) {
                    timeZone = ((TimeZoneAwareLocaleContext)localeContext).getTimeZone();
                }
                this.addCookie(exchange.getResponse(), QUOTE + (locale != null ? locale.toString() : "-") + (String)(timeZone != null ? " " + timeZone.getID() : "") + QUOTE);
            } else {
                this.removeCookie(exchange.getResponse());
            }
            exchange.getAttributes().put(LOCALE_REQUEST_ATTRIBUTE_NAME, locale != null ? locale : LocaleContextHolder.getLocale((LocaleContext)exchange.getLocaleContext()));
            if (timeZone != null) {
                exchange.getAttributes().put(TIME_ZONE_REQUEST_ATTRIBUTE_NAME, timeZone);
            } else {
                exchange.getAttributes().remove(TIME_ZONE_REQUEST_ATTRIBUTE_NAME);
            }
        }

        private void addCookie(@Nonnull ServerHttpResponse response, String cookieValue) {
            Assert.notNull((Object)response, (String)"ServerHttpResponse must not be null");
            ResponseCookie cookie = ResponseCookie.from((String)COOKIE_NAME, (String)cookieValue).path(COOKIE_PATH).build();
            response.addCookie(cookie);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Added cookie with name [NG_TRANSLATE_LANG_KEY] and value [" + cookieValue + "]"));
            }
        }

        private void removeCookie(@Nonnull ServerHttpResponse response) {
            Assert.notNull((Object)response, (String)"ServerHttpResponse must not be null");
            ResponseCookie cookie = ResponseCookie.from((String)COOKIE_NAME, (String)"").path(COOKIE_PATH).maxAge(Duration.ZERO).build();
            response.addCookie(cookie);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Removed cookie with name [NG_TRANSLATE_LANG_KEY]");
            }
        }

        private void parseLocaleCookieIfNecessary(ServerWebExchange exchange) {
            if (exchange.getAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME) == null) {
                HttpCookie cookie = (HttpCookie)exchange.getRequest().getCookies().getFirst((Object)COOKIE_NAME);
                Locale locale = null;
                TimeZone timeZone = null;
                if (cookie != null) {
                    String value = cookie.getValue();
                    String localePart = value = StringUtils.replace((String)value, (String)QUOTE, (String)"");
                    String timeZonePart = null;
                    int spaceIndex = localePart.indexOf(32);
                    if (spaceIndex != -1) {
                        localePart = value.substring(0, spaceIndex);
                        timeZonePart = value.substring(spaceIndex + 1);
                    }
                    Locale locale2 = locale = !"-".equals(localePart) ? StringUtils.parseLocaleString((String)localePart.replace('-', '_')) : null;
                    if (timeZonePart != null) {
                        timeZone = StringUtils.parseTimeZoneString(timeZonePart);
                    }
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)("Parsed cookie value [" + cookie.getValue() + "] into locale '" + locale + "'" + (String)(timeZone != null ? " and time zone '" + timeZone.getID() + "'" : "")));
                    }
                }
                if (locale != null) {
                    exchange.getAttributes().put(LOCALE_REQUEST_ATTRIBUTE_NAME, locale);
                }
                if (timeZone != null) {
                    exchange.getAttributes().put(TIME_ZONE_REQUEST_ATTRIBUTE_NAME, timeZone);
                } else {
                    exchange.getAttributes().remove(TIME_ZONE_REQUEST_ATTRIBUTE_NAME);
                }
            }
        }
    }
}

