/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.web.rest.errors;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindException;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingPathVariableException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.async.AsyncRequestTimeoutException;
import org.springframework.web.multipart.support.MissingServletRequestPartException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public abstract class ResponseEntityExceptionHandler {
    public static final String PAGE_NOT_FOUND_LOG_CATEGORY = "org.springframework.web.servlet.PageNotFound";
    protected static final Log pageNotFoundLogger = LogFactory.getLog((String)"org.springframework.web.servlet.PageNotFound");
    protected final Log logger = LogFactory.getLog(this.getClass());

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class, HttpMediaTypeNotSupportedException.class, HttpMediaTypeNotAcceptableException.class, MissingPathVariableException.class, MissingServletRequestParameterException.class, ServletRequestBindingException.class, ConversionNotSupportedException.class, TypeMismatchException.class, HttpMessageNotReadableException.class, HttpMessageNotWritableException.class, MethodArgumentNotValidException.class, MissingServletRequestPartException.class, BindException.class, AsyncRequestTimeoutException.class})
    @Nullable
    public final Mono<ResponseEntity<Object>> handleException(Exception ex, ServerWebExchange exchange) {
        HttpHeaders headers = new HttpHeaders();
        if (ex instanceof HttpRequestMethodNotSupportedException) {
            HttpStatus status = HttpStatus.METHOD_NOT_ALLOWED;
            return this.handleHttpRequestMethodNotSupported((HttpRequestMethodNotSupportedException)ex, headers, status, exchange);
        }
        if (ex instanceof HttpMediaTypeNotSupportedException) {
            HttpStatus status = HttpStatus.UNSUPPORTED_MEDIA_TYPE;
            return this.handleHttpMediaTypeNotSupported((HttpMediaTypeNotSupportedException)ex, headers, status, exchange);
        }
        if (ex instanceof HttpMediaTypeNotAcceptableException) {
            HttpStatus status = HttpStatus.NOT_ACCEPTABLE;
            return this.handleHttpMediaTypeNotAcceptable((HttpMediaTypeNotAcceptableException)ex, headers, status, exchange);
        }
        if (ex instanceof MissingPathVariableException) {
            HttpStatus status = HttpStatus.INTERNAL_SERVER_ERROR;
            return this.handleMissingPathVariable((MissingPathVariableException)ex, headers, status, exchange);
        }
        if (ex instanceof MissingServletRequestParameterException) {
            HttpStatus status = HttpStatus.BAD_REQUEST;
            return this.handleMissingServletRequestParameter((MissingServletRequestParameterException)ex, headers, status, exchange);
        }
        if (ex instanceof ServletRequestBindingException) {
            HttpStatus status = HttpStatus.BAD_REQUEST;
            return this.handleServletRequestBindingException((ServletRequestBindingException)ex, headers, status, exchange);
        }
        if (ex instanceof ConversionNotSupportedException) {
            HttpStatus status = HttpStatus.INTERNAL_SERVER_ERROR;
            return this.handleConversionNotSupported((ConversionNotSupportedException)ex, headers, status, exchange);
        }
        if (ex instanceof TypeMismatchException) {
            HttpStatus status = HttpStatus.BAD_REQUEST;
            return this.handleTypeMismatch((TypeMismatchException)ex, headers, status, exchange);
        }
        if (ex instanceof HttpMessageNotReadableException) {
            HttpStatus status = HttpStatus.BAD_REQUEST;
            return this.handleHttpMessageNotReadable((HttpMessageNotReadableException)ex, headers, status, exchange);
        }
        if (ex instanceof HttpMessageNotWritableException) {
            HttpStatus status = HttpStatus.INTERNAL_SERVER_ERROR;
            return this.handleHttpMessageNotWritable((HttpMessageNotWritableException)ex, headers, status, exchange);
        }
        if (ex instanceof MethodArgumentNotValidException) {
            HttpStatus status = HttpStatus.BAD_REQUEST;
            return this.handleMethodArgumentNotValid((MethodArgumentNotValidException)ex, headers, status, exchange);
        }
        if (ex instanceof MissingServletRequestPartException) {
            HttpStatus status = HttpStatus.BAD_REQUEST;
            return this.handleMissingServletRequestPart((MissingServletRequestPartException)ex, headers, status, exchange);
        }
        if (ex instanceof BindException) {
            HttpStatus status = HttpStatus.BAD_REQUEST;
            return this.handleBindException((BindException)ex, headers, status, exchange);
        }
        if (ex instanceof AsyncRequestTimeoutException) {
            HttpStatus status = HttpStatus.SERVICE_UNAVAILABLE;
            return this.handleAsyncRequestTimeoutException((AsyncRequestTimeoutException)ex, headers, status, exchange);
        }
        return Mono.error((Throwable)ex);
    }

    protected Mono<ResponseEntity<Object>> handleHttpRequestMethodNotSupported(HttpRequestMethodNotSupportedException ex, HttpHeaders headers, HttpStatus status, ServerWebExchange exchange) {
        pageNotFoundLogger.warn((Object)ex.getMessage());
        Set supportedMethods = ex.getSupportedHttpMethods();
        if (!CollectionUtils.isEmpty((Collection)supportedMethods)) {
            headers.setAllow(supportedMethods);
        }
        return this.handleExceptionInternal((Exception)ex, null, headers, status, exchange);
    }

    protected Mono<ResponseEntity<Object>> handleHttpMediaTypeNotSupported(HttpMediaTypeNotSupportedException ex, HttpHeaders headers, HttpStatus status, ServerWebExchange exchange) {
        List mediaTypes = ex.getSupportedMediaTypes();
        if (!CollectionUtils.isEmpty((Collection)mediaTypes)) {
            ServletWebRequest servletWebRequest;
            headers.setAccept(mediaTypes);
            if (exchange.getRequest() instanceof ServletWebRequest && HttpMethod.PATCH.equals((Object)(servletWebRequest = (ServletWebRequest)exchange.getRequest()).getHttpMethod())) {
                headers.setAcceptPatch(mediaTypes);
            }
        }
        return this.handleExceptionInternal((Exception)ex, null, headers, status, exchange);
    }

    protected Mono<ResponseEntity<Object>> handleHttpMediaTypeNotAcceptable(HttpMediaTypeNotAcceptableException ex, HttpHeaders headers, HttpStatus status, ServerWebExchange exchange) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, exchange);
    }

    protected Mono<ResponseEntity<Object>> handleMissingPathVariable(MissingPathVariableException ex, HttpHeaders headers, HttpStatus status, ServerWebExchange exchange) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, exchange);
    }

    protected Mono<ResponseEntity<Object>> handleMissingServletRequestParameter(MissingServletRequestParameterException ex, HttpHeaders headers, HttpStatus status, ServerWebExchange exchange) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, exchange);
    }

    protected Mono<ResponseEntity<Object>> handleServletRequestBindingException(ServletRequestBindingException ex, HttpHeaders headers, HttpStatus status, ServerWebExchange exchange) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, exchange);
    }

    protected Mono<ResponseEntity<Object>> handleConversionNotSupported(ConversionNotSupportedException ex, HttpHeaders headers, HttpStatus status, ServerWebExchange exchange) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, exchange);
    }

    protected Mono<ResponseEntity<Object>> handleTypeMismatch(TypeMismatchException ex, HttpHeaders headers, HttpStatus status, ServerWebExchange exchange) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, exchange);
    }

    protected Mono<ResponseEntity<Object>> handleHttpMessageNotReadable(HttpMessageNotReadableException ex, HttpHeaders headers, HttpStatus status, ServerWebExchange exchange) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, exchange);
    }

    protected Mono<ResponseEntity<Object>> handleHttpMessageNotWritable(HttpMessageNotWritableException ex, HttpHeaders headers, HttpStatus status, ServerWebExchange exchange) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, exchange);
    }

    protected Mono<ResponseEntity<Object>> handleMethodArgumentNotValid(MethodArgumentNotValidException ex, HttpHeaders headers, HttpStatus status, ServerWebExchange exchange) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, exchange);
    }

    protected Mono<ResponseEntity<Object>> handleMissingServletRequestPart(MissingServletRequestPartException ex, HttpHeaders headers, HttpStatus status, ServerWebExchange exchange) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, exchange);
    }

    protected Mono<ResponseEntity<Object>> handleBindException(BindException ex, HttpHeaders headers, HttpStatus status, ServerWebExchange exchange) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, exchange);
    }

    @Nullable
    protected Mono<ResponseEntity<Object>> handleAsyncRequestTimeoutException(AsyncRequestTimeoutException ex, HttpHeaders headers, HttpStatus status, ServerWebExchange exchange) {
        if (exchange.getResponse().isCommitted()) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)"Async request timed out");
            }
            return null;
        }
        return this.handleExceptionInternal((Exception)ex, null, headers, status, exchange);
    }

    protected Mono<ResponseEntity<Object>> handleExceptionInternal(Exception ex, @Nullable Object body, HttpHeaders headers, HttpStatus status, ServerWebExchange exchange) {
        if (exchange.getResponse().isCommitted()) {
            return Mono.error((Throwable)ex);
        }
        return this.createResponseEntity(body, headers, status, exchange);
    }

    protected Mono<ResponseEntity<Object>> createResponseEntity(@Nullable Object body, HttpHeaders headers, HttpStatus status, ServerWebExchange exchange) {
        return Mono.just((Object)new ResponseEntity(body, (MultiValueMap)headers, status));
    }
}

