/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.web.rest.errors;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.lang.Nullable;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public abstract class ResponseEntityExceptionHandler {
    public static final String PAGE_NOT_FOUND_LOG_CATEGORY = "org.springframework.web.servlet.PageNotFound";
    protected static final Log pageNotFoundLogger = LogFactory.getLog((String)"org.springframework.web.servlet.PageNotFound");
    protected final Log logger = LogFactory.getLog(this.getClass());

    @ExceptionHandler(value={ConversionNotSupportedException.class, TypeMismatchException.class, HttpMessageNotReadableException.class, HttpMessageNotWritableException.class, MethodArgumentNotValidException.class, BindException.class})
    @Nullable
    public final Mono<ResponseEntity<Object>> handleException(Exception ex, ServerWebExchange exchange) {
        HttpHeaders headers = new HttpHeaders();
        if (ex instanceof ConversionNotSupportedException) {
            HttpStatus status = HttpStatus.INTERNAL_SERVER_ERROR;
            return this.handleConversionNotSupported((ConversionNotSupportedException)ex, headers, status, exchange);
        }
        if (ex instanceof TypeMismatchException) {
            HttpStatus status = HttpStatus.BAD_REQUEST;
            return this.handleTypeMismatch((TypeMismatchException)ex, headers, status, exchange);
        }
        if (ex instanceof HttpMessageNotReadableException) {
            HttpStatus status = HttpStatus.BAD_REQUEST;
            return this.handleHttpMessageNotReadable((HttpMessageNotReadableException)ex, headers, status, exchange);
        }
        if (ex instanceof HttpMessageNotWritableException) {
            HttpStatus status = HttpStatus.INTERNAL_SERVER_ERROR;
            return this.handleHttpMessageNotWritable((HttpMessageNotWritableException)ex, headers, status, exchange);
        }
        if (ex instanceof MethodArgumentNotValidException) {
            HttpStatus status = HttpStatus.BAD_REQUEST;
            return this.handleMethodArgumentNotValid((MethodArgumentNotValidException)ex, headers, status, exchange);
        }
        if (ex instanceof BindException) {
            HttpStatus status = HttpStatus.BAD_REQUEST;
            return this.handleBindException((BindException)ex, headers, status, exchange);
        }
        return Mono.error((Throwable)ex);
    }

    protected Mono<ResponseEntity<Object>> handleConversionNotSupported(ConversionNotSupportedException ex, HttpHeaders headers, HttpStatus status, ServerWebExchange exchange) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, exchange);
    }

    protected Mono<ResponseEntity<Object>> handleTypeMismatch(TypeMismatchException ex, HttpHeaders headers, HttpStatus status, ServerWebExchange exchange) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, exchange);
    }

    protected Mono<ResponseEntity<Object>> handleHttpMessageNotReadable(HttpMessageNotReadableException ex, HttpHeaders headers, HttpStatus status, ServerWebExchange exchange) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, exchange);
    }

    protected Mono<ResponseEntity<Object>> handleHttpMessageNotWritable(HttpMessageNotWritableException ex, HttpHeaders headers, HttpStatus status, ServerWebExchange exchange) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, exchange);
    }

    protected Mono<ResponseEntity<Object>> handleMethodArgumentNotValid(MethodArgumentNotValidException ex, HttpHeaders headers, HttpStatus status, ServerWebExchange exchange) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, exchange);
    }

    protected Mono<ResponseEntity<Object>> handleBindException(BindException ex, HttpHeaders headers, HttpStatus status, ServerWebExchange exchange) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, exchange);
    }

    protected Mono<ResponseEntity<Object>> handleExceptionInternal(Exception ex, @Nullable Object body, HttpHeaders headers, HttpStatus status, ServerWebExchange exchange) {
        if (exchange.getResponse().isCommitted()) {
            return Mono.error((Throwable)ex);
        }
        return this.createResponseEntity(body, headers, status, exchange);
    }

    protected Mono<ResponseEntity<Object>> createResponseEntity(@Nullable Object body, HttpHeaders headers, HttpStatus status, ServerWebExchange exchange) {
        return Mono.just((Object)new ResponseEntity(body, (MultiValueMap)headers, status));
    }
}

