/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
public final class NtsSecurityUtils
implements InitializingBean {
    private final String rolesClaim;
    private final String rolePrefix;
    private final boolean reverseOrderOfDisplayName;
    private static NtsSecurityUtils instance;

    public NtsSecurityUtils(@Value(value="${nts.security.oauth2.client.configuration.roles-claim:roles}") String rolesClaim, @Value(value="${nts.security.oauth2.client.configuration.role-prefix:ROLE_}") String rolePrefix, @Value(value="${nts.security.oauth2.client.configuration.reverse-order-of-display-name:true}") boolean reverseOrderOfDisplayName) {
        this.rolesClaim = rolesClaim;
        this.rolePrefix = rolePrefix;
        this.reverseOrderOfDisplayName = reverseOrderOfDisplayName;
    }

    public static Mono<String> getCurrentUserLogin() {
        return ReactiveSecurityContextHolder.getContext().map(SecurityContext::getAuthentication).flatMap(authentication -> Mono.justOrEmpty((Object)NtsSecurityUtils.extractPrincipal(authentication)));
    }

    private static String extractPrincipal(Authentication authentication) {
        if (authentication == null) {
            return null;
        }
        if (authentication.getPrincipal() instanceof UserDetails) {
            UserDetails springSecurityUser = (UserDetails)authentication.getPrincipal();
            return springSecurityUser.getUsername();
        }
        if (authentication instanceof JwtAuthenticationToken) {
            return (String)((Jwt)((JwtAuthenticationToken)authentication).getToken()).getClaims().get("preferred_username");
        }
        if (authentication.getPrincipal() instanceof DefaultOidcUser) {
            Map attributes = ((DefaultOidcUser)authentication.getPrincipal()).getAttributes();
            if (attributes.containsKey("preferred_username")) {
                return (String)attributes.get("preferred_username");
            }
        } else if (authentication.getPrincipal() instanceof String) {
            return (String)authentication.getPrincipal();
        }
        return null;
    }

    public static Mono<String> getCurrentUserDisplayName() {
        return ReactiveSecurityContextHolder.getContext().map(SecurityContext::getAuthentication).flatMap(authentication -> Mono.justOrEmpty((Object)NtsSecurityUtils.extractDisplayName(authentication)));
    }

    private static String extractDisplayName(Authentication authentication) {
        String firstName = null;
        String lastName = null;
        if (authentication == null) {
            return null;
        }
        if (authentication.getPrincipal() instanceof UserDetails) {
            UserDetails springSecurityUser = (UserDetails)authentication.getPrincipal();
            firstName = springSecurityUser.getUsername();
        } else if (authentication instanceof JwtAuthenticationToken) {
            firstName = (String)((Jwt)((JwtAuthenticationToken)authentication).getToken()).getClaims().get("given_name");
            lastName = (String)((Jwt)((JwtAuthenticationToken)authentication).getToken()).getClaims().get("family_name");
        } else if (authentication.getPrincipal() instanceof DefaultOidcUser) {
            Map attributes = ((DefaultOidcUser)authentication.getPrincipal()).getAttributes();
            if (attributes.containsKey("given_name")) {
                firstName = (String)attributes.get("given_name");
            }
            if (attributes.containsKey("family_name")) {
                lastName = (String)attributes.get("family_name");
            }
        } else if (authentication.getPrincipal() instanceof String) {
            firstName = (String)authentication.getPrincipal();
        }
        String displayName = Stream.of(firstName, lastName).sorted(NtsSecurityUtils.instance.reverseOrderOfDisplayName ? Comparator.reverseOrder() : Comparator.naturalOrder()).map(StringUtils::trimToNull).filter(Objects::nonNull).collect(Collectors.joining(" "));
        return StringUtils.trimToNull((String)displayName);
    }

    public static Mono<Boolean> isAuthenticated() {
        return ReactiveSecurityContextHolder.getContext().map(SecurityContext::getAuthentication).map(Authentication::getAuthorities).map(authorities -> authorities.stream().map(GrantedAuthority::getAuthority).noneMatch("ROLE_ANONYMOUS"::equals));
    }

    public static Mono<Boolean> hasCurrentUserAnyOfAuthorities(String ... authorities) {
        return ReactiveSecurityContextHolder.getContext().map(SecurityContext::getAuthentication).map(Authentication::getAuthorities).map(authorityList -> authorityList.stream().map(GrantedAuthority::getAuthority).anyMatch(authority -> Arrays.asList(authorities).contains(authority)));
    }

    public static Mono<Boolean> hasCurrentUserNoneOfAuthorities(String ... authorities) {
        return NtsSecurityUtils.hasCurrentUserAnyOfAuthorities(authorities).map(result -> result == false);
    }

    public static Mono<Boolean> hasCurrentUserThisAuthority(String authority) {
        return NtsSecurityUtils.hasCurrentUserAnyOfAuthorities(authority);
    }

    public static List<GrantedAuthority> extractAuthorityFromClaims(Map<String, Object> claims) {
        return NtsSecurityUtils.mapRolesToGrantedAuthorities(NtsSecurityUtils.getRolesFromClaims(claims));
    }

    private static Collection<String> getRolesFromClaims(Map<String, Object> claims) {
        return claims.getOrDefault(NtsSecurityUtils.instance.rolesClaim, new ArrayList());
    }

    private static List<GrantedAuthority> mapRolesToGrantedAuthorities(Collection<String> roles) {
        return roles.stream().filter(role -> role.startsWith(NtsSecurityUtils.instance.rolePrefix)).map(SimpleGrantedAuthority::new).collect(Collectors.toList());
    }

    public void afterPropertiesSet() {
        instance = this;
    }
}

