/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.service.errors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.http.HttpStatus;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.client.HttpStatusCodeException;

public class NtsValidationException
extends HttpStatusCodeException {
    private static final long serialVersionUID = 1L;
    protected final Map<String, List<String>> errors;

    public NtsValidationException() {
        super(HttpStatus.UNPROCESSABLE_ENTITY);
        this.errors = new LinkedHashMap<String, List<String>>();
    }

    public NtsValidationException(Map<String, List<String>> errors) {
        super(NtsValidationException.buildMessage(errors), HttpStatus.UNPROCESSABLE_ENTITY, HttpStatus.UNPROCESSABLE_ENTITY.getReasonPhrase(), null, null, null);
        this.errors = errors;
    }

    public NtsValidationException(String key, String message) {
        super(StringUtils.join((Object[])new String[]{key, ": ", message}), HttpStatus.UNPROCESSABLE_ENTITY, HttpStatus.UNPROCESSABLE_ENTITY.getReasonPhrase(), null, null, null);
        this.errors = Collections.singletonMap(key, Collections.singletonList(message));
    }

    public NtsValidationException(BindingResult bindingResult) {
        super(NtsValidationException.buildMessage(bindingResult), HttpStatus.UNPROCESSABLE_ENTITY, HttpStatus.UNPROCESSABLE_ENTITY.getReasonPhrase(), null, null, null);
        this.errors = NtsValidationException.buildErrors(bindingResult);
    }

    public Map<String, List<String>> getErrors() {
        return this.errors;
    }

    public boolean hasFieldErrors() {
        return !this.errors.isEmpty();
    }

    public void addFieldError(String field, String error) {
        List messages = this.errors.getOrDefault(field, new ArrayList());
        messages.add(error);
        this.errors.putIfAbsent(field, messages);
    }

    public void addFieldErrors(Map<String, List<String>> fieldErrors) {
        this.addFieldErrors(fieldErrors, null);
    }

    public void addFieldErrors(Map<String, List<String>> fieldErrors, String prefix) {
        if (CollectionUtils.isEmpty(fieldErrors)) {
            return;
        }
        fieldErrors.forEach((key, newMessages) -> {
            String fieldName = StringUtils.join((Object[])new String[]{prefix, key});
            List messages = this.errors.getOrDefault(fieldName, new ArrayList());
            messages.addAll(newMessages);
            this.errors.putIfAbsent(fieldName, messages);
        });
    }

    public static String buildMessage(Map<String, List<String>> fieldErrors) {
        if (fieldErrors == null || fieldErrors.isEmpty()) {
            return null;
        }
        return fieldErrors.entrySet().stream().map(entry -> String.format("%s: %s", entry.getKey(), entry.getValue())).collect(Collectors.joining(", "));
    }

    public static String buildMessage(BindingResult bindingResult) {
        if (bindingResult == null || !bindingResult.hasFieldErrors()) {
            return null;
        }
        return bindingResult.getFieldErrors().stream().map(fieldError -> String.format("%s: %s", fieldError.getField(), fieldError.getDefaultMessage())).collect(Collectors.joining(", "));
    }

    public static Map<String, List<String>> buildErrors(BindingResult bindingResult) {
        if (bindingResult == null || !bindingResult.hasErrors()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, List<String>> errors = new LinkedHashMap<String, List<String>>();
        if (!CollectionUtils.isEmpty((Collection)bindingResult.getGlobalErrors())) {
            List baseErrors = bindingResult.getGlobalErrors().stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.toList());
            errors.put("base", baseErrors);
        }
        if (!CollectionUtils.isEmpty((Collection)bindingResult.getFieldErrors())) {
            Map<String, List> fieldErrors = bindingResult.getFieldErrors().stream().collect(Collectors.groupingBy(FieldError::getField, Collectors.collectingAndThen(Collectors.toList(), items -> items.stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.toList()))));
            errors.putAll(fieldErrors);
        }
        return errors;
    }
}

