/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.web.rest.errors;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.nentangso.core.service.utils.NtsTextUtils;
import org.nentangso.core.web.rest.errors.NtsProblem;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.server.ServerWebExchange;
import org.zalando.problem.Problem;
import org.zalando.problem.Status;
import org.zalando.problem.StatusType;
import org.zalando.problem.spring.webflux.advice.ProblemHandling;
import org.zalando.problem.spring.webflux.advice.security.SecurityAdviceTrait;
import org.zalando.problem.violations.ConstraintViolationProblem;
import org.zalando.problem.violations.Violation;
import reactor.core.publisher.Mono;

@ConditionalOnProperty(prefix="nts.web.rest.exception-translator", name={"enabled"}, havingValue="true", matchIfMissing=true)
@ControllerAdvice
@ConditionalOnMissingBean(name={"exceptionTranslator"})
public class NtsExceptionTranslator
implements ProblemHandling,
SecurityAdviceTrait {
    public ResponseEntity<Problem> process(ResponseEntity<Problem> entity) {
        HttpStatus status = entity.getStatusCode();
        NtsProblem body = new NtsProblem();
        if (HttpStatus.UNAUTHORIZED.equals((Object)status)) {
            body.setErrors("[API] Invalid API key or access token (unrecognized login or wrong password)");
        } else if (HttpStatus.FORBIDDEN.equals((Object)status)) {
            body.setErrors("[API] This action requires merchant approval for the necessary scope.");
        } else if (HttpStatus.METHOD_NOT_ALLOWED.equals((Object)status)) {
            status = HttpStatus.NOT_ACCEPTABLE;
            body.setErrors(HttpStatus.NOT_ACCEPTABLE.getReasonPhrase());
        } else if (HttpStatus.UNPROCESSABLE_ENTITY.equals((Object)status) && entity.getBody() != null) {
            Problem input = (Problem)entity.getBody();
            if (input instanceof ConstraintViolationProblem) {
                Map errors = ((ConstraintViolationProblem)input).getViolations().stream().collect(Collectors.groupingBy(Violation::getField, Collectors.mapping(Violation::getMessage, Collectors.toList())));
                body.setErrors(errors);
            } else {
                body.setErrors(Collections.singletonMap("base", "Required parameter missing or invalid"));
            }
        } else {
            body.setErrors(status.getReasonPhrase());
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)status).headers(entity.getHeaders())).contentType(MediaType.APPLICATION_JSON).body((Object)body);
    }

    public StatusType defaultConstraintViolationStatus() {
        return Status.UNPROCESSABLE_ENTITY;
    }

    public String formatFieldName(@Nullable String fieldName) {
        return Optional.ofNullable(fieldName).map(NtsTextUtils::toSnakeCase).orElse("base");
    }

    @ExceptionHandler
    Mono<ResponseEntity<Problem>> handleConcurrencyFailureException(ConcurrencyFailureException exception, ServerWebExchange request) {
        return this.create((StatusType)Status.CONFLICT, (Throwable)exception, request);
    }
}

