/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.client;

import java.util.Collection;
import java.util.Map;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.core.AbstractOAuth2Token;
import reactivefeign.client.ReactiveHttpRequest;
import reactivefeign.client.ReactiveHttpRequestInterceptor;
import reactivefeign.utils.MultiValueMapUtils;
import reactor.core.publisher.Mono;

public class NtsKeycloakRequestInterceptor
implements ReactiveHttpRequestInterceptor {
    public static final Authentication ANONYMOUS_USER_AUTHENTICATION = new AnonymousAuthenticationToken("key", (Object)"anonymous", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_ANONYMOUS"}));
    private final ReactiveOAuth2AuthorizedClientManager authorizedClientManager;
    private final String clientRegistrationId;

    public NtsKeycloakRequestInterceptor(ReactiveOAuth2AuthorizedClientManager authorizedClientManager, String clientRegistrationId) {
        this.authorizedClientManager = authorizedClientManager;
        this.clientRegistrationId = clientRegistrationId;
    }

    public Mono<ReactiveHttpRequest> apply(ReactiveHttpRequest request) {
        return this.getAuthenticationToken(this.clientRegistrationId).map(accessToken -> {
            MultiValueMapUtils.addOrdered((Map)request.headers(), (Object)"Authorization", (Object)accessToken);
            return request;
        });
    }

    public Mono<String> getAuthenticationToken(String clientRegistrationId) {
        OAuth2AuthorizeRequest request = OAuth2AuthorizeRequest.withClientRegistrationId((String)clientRegistrationId).principal(ANONYMOUS_USER_AUTHENTICATION).build();
        return this.authorizedClientManager.authorize(request).map(OAuth2AuthorizedClient::getAccessToken).map(AbstractOAuth2Token::getTokenValue).map(accessToken -> "Bearer " + accessToken);
    }
}

