/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.repository;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanComparator;
import org.nentangso.core.domain.NtsAuthority;
import org.nentangso.core.domain.NtsUserEntity;
import org.nentangso.core.repository.NtsUserRepositoryInternal;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.r2dbc.convert.R2dbcConverter;
import org.springframework.data.r2dbc.core.R2dbcEntityTemplate;
import org.springframework.r2dbc.core.DatabaseClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

class NtsUserRepositoryInternalImpl
implements NtsUserRepositoryInternal {
    private final DatabaseClient db;
    private final R2dbcEntityTemplate r2dbcEntityTemplate;
    private final R2dbcConverter r2dbcConverter;

    public NtsUserRepositoryInternalImpl(DatabaseClient db, R2dbcEntityTemplate r2dbcEntityTemplate, R2dbcConverter r2dbcConverter) {
        this.db = db;
        this.r2dbcEntityTemplate = r2dbcEntityTemplate;
        this.r2dbcConverter = r2dbcConverter;
    }

    @Override
    public Mono<NtsUserEntity> findOneWithAuthoritiesByLogin(String login) {
        return this.findOneWithAuthoritiesBy("login", login);
    }

    @Override
    public Flux<NtsUserEntity> findAllWithAuthorities(Pageable pageable) {
        String property = pageable.getSort().stream().map(Sort.Order::getProperty).findFirst().orElse("id");
        String direction = String.valueOf(pageable.getSort().stream().map(Sort.Order::getDirection).findFirst().orElse(Sort.DEFAULT_DIRECTION));
        long page = pageable.getPageNumber();
        long size = pageable.getPageSize();
        return this.db.sql("SELECT * FROM nts_user u LEFT JOIN nts_user_authorities ua ON u.id=ua.user_id").map((row, metadata) -> Tuples.of((Object)((NtsUserEntity)this.r2dbcConverter.read(NtsUserEntity.class, row, metadata)), Optional.ofNullable((String)row.get("authority_name", String.class)))).all().groupBy(t -> ((NtsUserEntity)t.getT1()).getLogin()).flatMap(l -> l.collectList().map(t -> this.updateUserWithAuthorities((NtsUserEntity)((Tuple2)t.get(0)).getT1(), (List<Tuple2<NtsUserEntity, Optional<String>>>)t))).sort((Comparator)(Sort.Direction.fromString((String)direction) == Sort.DEFAULT_DIRECTION ? new BeanComparator(property) : new BeanComparator(property).reversed())).skip(page * size).take(size);
    }

    @Override
    public Mono<NtsUserEntity> create(NtsUserEntity user) {
        return this.r2dbcEntityTemplate.insert(NtsUserEntity.class).using((Object)user).defaultIfEmpty((Object)user);
    }

    private Mono<NtsUserEntity> findOneWithAuthoritiesBy(String fieldName, Object fieldValue) {
        return this.db.sql("SELECT * FROM nts_user u LEFT JOIN nts_user_authorities ua ON u.id=ua.user_id WHERE u." + fieldName + " = :" + fieldName).bind(fieldName, fieldValue).map((row, metadata) -> Tuples.of((Object)((NtsUserEntity)this.r2dbcConverter.read(NtsUserEntity.class, row, metadata)), Optional.ofNullable((String)row.get("authority_name", String.class)))).all().collectList().filter(l -> !l.isEmpty()).map(l -> this.updateUserWithAuthorities((NtsUserEntity)((Tuple2)l.get(0)).getT1(), (List<Tuple2<NtsUserEntity, Optional<String>>>)l));
    }

    private NtsUserEntity updateUserWithAuthorities(NtsUserEntity user, List<Tuple2<NtsUserEntity, Optional<String>>> tuples) {
        user.setAuthorities(tuples.stream().filter(t -> ((Optional)t.getT2()).isPresent()).map(t -> {
            NtsAuthority authority = new NtsAuthority();
            authority.setName((String)((Optional)t.getT2()).get());
            return authority;
        }).collect(Collectors.toSet()));
        return user;
    }
}

