/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.config;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.Map;
import java.util.Set;
import org.nentangso.core.service.dto.NtsDefaultLocationDTO;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.core.ReactiveRedisOperations;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@ConditionalOnProperty(prefix="nts.helper.location", name={"provider"}, havingValue="keycloak")
@Configuration
public class NtsKeycloakCacheConfiguration {
    @Bean
    ReactiveRedisOperations<String, Map<Long, NtsDefaultLocationDTO>> ntsLocationsOps(ReactiveRedisConnectionFactory factory, ObjectMapper objectMapper) {
        MapType type = MapType.construct(Map.class, (TypeBindings)TypeBindings.create(Set.class, (JavaType)SimpleType.constructUnsafe(NtsDefaultLocationDTO.class)), (JavaType)TypeFactory.unknownType(), null, (JavaType)SimpleType.constructUnsafe(Long.class), (JavaType)SimpleType.constructUnsafe(NtsDefaultLocationDTO.class));
        Jackson2JsonRedisSerializer serializer = new Jackson2JsonRedisSerializer((JavaType)type);
        serializer.setObjectMapper(objectMapper);
        RedisSerializationContext.RedisSerializationContextBuilder builder = RedisSerializationContext.newSerializationContext((RedisSerializer)new StringRedisSerializer());
        RedisSerializationContext context = builder.value((RedisSerializer)serializer).build();
        return new ReactiveRedisTemplate(factory, context);
    }
}

