/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.service;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.nentangso.core.domain.NtsAuthority;
import org.nentangso.core.domain.NtsUserEntity;
import org.nentangso.core.repository.NtsAuthorityRepository;
import org.nentangso.core.repository.NtsUserRepository;
import org.nentangso.core.security.NtsSecurityUtils;
import org.nentangso.core.service.dto.NtsAdminUserDTO;
import org.nentangso.core.service.dto.NtsUserDTO;
import org.nentangso.core.service.mapper.NtsUserMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.data.domain.Pageable;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
@ConditionalOnMissingBean(name={"userService"})
public class NtsUserService {
    private final Logger log = LoggerFactory.getLogger(NtsUserService.class);
    private final NtsUserRepository userRepository;
    private final NtsAuthorityRepository authorityRepository;
    private final NtsUserMapper userMapper;

    public NtsUserService(NtsUserRepository userRepository, NtsAuthorityRepository authorityRepository, NtsUserMapper userMapper) {
        this.userRepository = userRepository;
        this.authorityRepository = authorityRepository;
        this.userMapper = userMapper;
    }

    @Transactional
    public Mono<Void> updateUser(String firstName, String lastName, String email, String langKey, String imageUrl) {
        return NtsSecurityUtils.getCurrentUserLogin().flatMap(this.userRepository::findOneByLogin).flatMap(user -> {
            user.setFirstName(firstName);
            user.setLastName(lastName);
            if (email != null) {
                user.setEmail(email.toLowerCase());
            }
            user.setLangKey(langKey);
            user.setImageUrl(imageUrl);
            return this.saveUser((NtsUserEntity)user);
        }).doOnNext(user -> this.log.debug("Changed Information for User: {}", user)).then();
    }

    @Transactional
    public Mono<NtsUserEntity> saveUser(NtsUserEntity user) {
        return this.saveUser(user, false);
    }

    @Transactional
    public Mono<NtsUserEntity> saveUser(NtsUserEntity user, boolean forceCreate) {
        return NtsSecurityUtils.getCurrentUserLogin().switchIfEmpty(Mono.just((Object)"system")).flatMap(login -> {
            if (user.getCreatedBy() == null) {
                user.setCreatedBy((String)login);
            }
            user.setUpdatedBy((String)login);
            Mono persistedUser = forceCreate ? this.userRepository.create(user) : this.userRepository.save(user);
            return persistedUser.flatMap(savedUser -> Flux.fromIterable(user.getAuthorities()).flatMap(authority -> this.userRepository.saveUserAuthority(savedUser.getId(), authority.getName())).then(Mono.just((Object)savedUser)));
        });
    }

    @Transactional(readOnly=true)
    public Flux<NtsAdminUserDTO> getAllManagedUsers(Pageable pageable) {
        return this.userRepository.findAllWithAuthorities(pageable).map(this.userMapper::userToAdminUserDTO);
    }

    @Transactional(readOnly=true)
    public Flux<NtsUserDTO> getAllPublicUsers(Pageable pageable) {
        return this.userRepository.findAllByIdNotNullAndActivatedIsTrue(pageable).map(this.userMapper::userToUserDTO);
    }

    @Transactional(readOnly=true)
    public Mono<Long> countManagedUsers() {
        return this.userRepository.count();
    }

    @Transactional(readOnly=true)
    public Mono<NtsUserEntity> getUserWithAuthoritiesByLogin(String login) {
        return this.userRepository.findOneWithAuthoritiesByLogin(login);
    }

    @Transactional(readOnly=true)
    public Flux<String> getAuthorities() {
        return this.authorityRepository.findAll().map(NtsAuthority::getName);
    }

    private Mono<NtsUserEntity> syncUserWithIdP(Map<String, Object> details, NtsUserEntity user) {
        Collection userAuthorities = user.getAuthorities().stream().map(NtsAuthority::getName).collect(Collectors.toList());
        return this.getAuthorities().collectList().flatMapMany(dbAuthorities -> {
            List authoritiesToSave = userAuthorities.stream().filter(authority -> !dbAuthorities.contains(authority)).map(authority -> {
                NtsAuthority authorityToSave = new NtsAuthority();
                authorityToSave.setName((String)authority);
                return authorityToSave;
            }).collect(Collectors.toList());
            return Flux.fromIterable(authoritiesToSave);
        }).doOnNext(authority -> this.log.debug("Saving authority '{}' in local database", authority)).flatMap(arg_0 -> ((NtsAuthorityRepository)this.authorityRepository).save(arg_0)).then(this.userRepository.findOneByLogin(user.getLogin())).switchIfEmpty(this.saveUser(user, true)).flatMap(existingUser -> {
            if (details.get("updated_at") != null) {
                Instant dbModifiedDate = existingUser.getUpdatedAt();
                Instant idpModifiedDate = details.get("updated_at") instanceof Instant ? (Instant)details.get("updated_at") : Instant.ofEpochSecond(((Integer)details.get("updated_at")).intValue());
                if (idpModifiedDate.isAfter(dbModifiedDate)) {
                    this.log.debug("Updating user '{}' in local database", (Object)user.getLogin());
                    return this.updateUser(user.getFirstName(), user.getLastName(), user.getEmail(), user.getLangKey(), user.getImageUrl());
                }
            } else {
                this.log.debug("Updating user '{}' in local database", (Object)user.getLogin());
                return this.updateUser(user.getFirstName(), user.getLastName(), user.getEmail(), user.getLangKey(), user.getImageUrl());
            }
            return Mono.empty();
        }).thenReturn((Object)user);
    }

    @Transactional
    public Mono<NtsAdminUserDTO> getUserFromAuthentication(AbstractAuthenticationToken authToken) {
        Map attributes;
        if (authToken instanceof OAuth2AuthenticationToken) {
            attributes = ((OAuth2AuthenticationToken)authToken).getPrincipal().getAttributes();
        } else if (authToken instanceof JwtAuthenticationToken) {
            attributes = ((JwtAuthenticationToken)authToken).getTokenAttributes();
        } else {
            throw new IllegalArgumentException("AuthenticationToken is not OAuth2 or JWT!");
        }
        NtsUserEntity user = NtsUserService.getUser(attributes);
        user.setAuthorities(authToken.getAuthorities().stream().map(GrantedAuthority::getAuthority).map(authority -> {
            NtsAuthority auth = new NtsAuthority();
            auth.setName((String)authority);
            return auth;
        }).collect(Collectors.toSet()));
        return this.syncUserWithIdP(attributes, user).flatMap(u -> Mono.just((Object)this.userMapper.userToAdminUserDTO(user)));
    }

    private static NtsUserEntity getUser(Map<String, Object> details) {
        NtsUserEntity user = new NtsUserEntity();
        Boolean activated = Boolean.TRUE;
        String sub = String.valueOf(details.get("sub"));
        String username = null;
        if (details.get("preferred_username") != null) {
            username = ((String)details.get("preferred_username")).toLowerCase();
        }
        if (details.get("uid") != null) {
            user.setId((String)details.get("uid"));
            user.setLogin(sub);
        } else {
            user.setId(sub);
        }
        if (username != null) {
            user.setLogin(username);
        } else if (user.getLogin() == null) {
            user.setLogin(user.getId());
        }
        if (details.get("given_name") != null) {
            user.setFirstName((String)details.get("given_name"));
        } else if (details.get("name") != null) {
            user.setFirstName((String)details.get("name"));
        }
        if (details.get("family_name") != null) {
            user.setLastName((String)details.get("family_name"));
        }
        if (details.get("email_verified") != null) {
            activated = (Boolean)details.get("email_verified");
        }
        if (details.get("email") != null) {
            user.setEmail(((String)details.get("email")).toLowerCase());
        } else if (sub.contains("|") && username != null && username.contains("@")) {
            user.setEmail(username);
        } else {
            user.setEmail(sub);
        }
        if (details.get("langKey") != null) {
            user.setLangKey((String)details.get("langKey"));
        } else if (details.get("locale") != null) {
            String locale = (String)details.get("locale");
            if (locale.contains("_")) {
                locale = locale.substring(0, locale.indexOf(95));
            } else if (locale.contains("-")) {
                locale = locale.substring(0, locale.indexOf(45));
            }
            user.setLangKey(locale.toLowerCase());
        } else {
            user.setLangKey("en");
        }
        if (details.get("picture") != null) {
            user.setImageUrl((String)details.get("picture"));
        }
        user.setActivated(activated);
        return user;
    }
}

