/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.service.errors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.validation.BindingResult;
import org.zalando.problem.Status;
import org.zalando.problem.StatusType;
import org.zalando.problem.violations.ConstraintViolationProblem;
import org.zalando.problem.violations.Violation;

public class NtsValidationException
extends ConstraintViolationProblem {
    private static final long serialVersionUID = 1L;

    public NtsValidationException() {
        super((StatusType)Status.UNPROCESSABLE_ENTITY, Collections.emptyList());
    }

    public NtsValidationException(Map<String, List<String>> errors) {
        super((StatusType)Status.UNPROCESSABLE_ENTITY, NtsValidationException.createViolations(errors));
    }

    private static List<Violation> createViolations(Map<String, List<String>> errors) {
        ArrayList<Violation> violations = new ArrayList<Violation>();
        Optional.ofNullable(errors).orElseGet(Collections::emptyMap).forEach((key, messages) -> violations.addAll(NtsValidationException.createViolations(key, messages)));
        return violations;
    }

    private static List<Violation> createViolations(String key, List<String> messages) {
        return Optional.ofNullable(messages).orElseGet(Collections::emptyList).stream().map(message -> NtsValidationException.createViolation(key, message)).collect(Collectors.toList());
    }

    private static Violation createViolation(String key, String message) {
        return new Violation(Optional.ofNullable(key).orElse("base"), message);
    }

    public NtsValidationException(String key, String message) {
        super((StatusType)Status.UNPROCESSABLE_ENTITY, Collections.singletonList(NtsValidationException.createViolation(key, message)));
    }

    public NtsValidationException(BindingResult bindingResult) {
        super((StatusType)Status.UNPROCESSABLE_ENTITY, NtsValidationException.createViolations(bindingResult));
    }

    private static List<Violation> createViolations(BindingResult bindingResult) {
        if (bindingResult == null || !bindingResult.hasErrors()) {
            return Collections.emptyList();
        }
        ArrayList<Violation> violations = new ArrayList<Violation>();
        bindingResult.getGlobalErrors().forEach(objectError -> violations.add(NtsValidationException.createViolation("base", objectError.getDefaultMessage())));
        bindingResult.getFieldErrors().forEach(fieldError -> violations.add(NtsValidationException.createViolation(fieldError.getField(), fieldError.getDefaultMessage())));
        return violations;
    }

    public void addViolation(String key, String message) {
        this.getViolations().add(NtsValidationException.createViolation(key, message));
    }

    public void addViolations(Map<String, List<String>> errors) {
        this.addViolations(errors, null);
    }

    public void addViolations(Map<String, List<String>> errors, String prefix) {
        Optional.ofNullable(errors).orElseGet(Collections::emptyMap).forEach((key, messages) -> {
            String fieldName = StringUtils.join((Object[])new String[]{prefix, key});
            List<Violation> violations = NtsValidationException.createViolations(fieldName, messages);
            this.getViolations().addAll(violations);
        });
    }
}

