/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.service.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.Min;
import org.nentangso.core.service.dto.NtsLocationDTO;
import org.nentangso.core.service.provider.NtsLocationProvider;
import org.nentangso.core.service.provider.NtsLocationProviderFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@ConditionalOnProperty(prefix="nts.helper.location", name={"enabled"}, havingValue="true")
@Service
public class NtsLocationHelper {
    private final NtsLocationProvider<? extends NtsLocationDTO> locationProvider;

    public NtsLocationHelper(NtsLocationProviderFactory locationProviderFactory) {
        this.locationProvider = locationProviderFactory.getLocationProvider();
    }

    public Mono<List<? extends NtsLocationDTO>> findAll() {
        return this.locationProvider.findAll().map(Map::values).map(ArrayList::new).map(Collections::unmodifiableList);
    }

    private Mono<Set<Long>> findAlIds() {
        return this.locationProvider.findAllIds();
    }

    public Mono<? extends NtsLocationDTO> findById(Long id) {
        return this.locationProvider.findById(id);
    }

    public Mono<Set<Long>> getGrantedLocationIds() {
        return this.locationProvider.getGrantedLocationIds();
    }

    public Mono<Boolean> isGrantedAllLocations() {
        return this.locationProvider.isGrantedAllLocations();
    }

    public Mono<Boolean> isGrantedAnyLocations(Iterable<Long> ids) {
        return this.locationProvider.isGrantedAnyLocations(ids);
    }

    public Mono<Boolean> isGrantedAnyLocations(Long ... ids) {
        return this.locationProvider.isGrantedAnyLocations(ids);
    }

    public Mono<Boolean> isGrantedLocation(@Min(value=1L) @Min(value=1L) Long id) {
        return this.locationProvider.isGrantedLocation(id);
    }
}

