/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.service.provider;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.validation.constraints.Min;
import org.apache.commons.lang3.StringUtils;
import org.nentangso.core.client.NtsKeycloakClient;
import org.nentangso.core.client.vm.KeycloakClientRole;
import org.nentangso.core.config.NtsKeycloakLocationProperties;
import org.nentangso.core.security.NtsSecurityUtils;
import org.nentangso.core.service.dto.NtsAttributeDTO;
import org.nentangso.core.service.dto.NtsDefaultAttributeDTO;
import org.nentangso.core.service.dto.NtsDefaultLocationDTO;
import org.nentangso.core.service.dto.NtsLocationDTO;
import org.nentangso.core.service.provider.NtsLocationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.redis.core.ReactiveRedisOperations;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ConditionalOnProperty(prefix="nts.helper.location", name={"provider"}, havingValue="keycloak")
@Service
public class NtsKeycloakLocationProvider
implements NtsLocationProvider<NtsDefaultLocationDTO> {
    private static final Logger log = LoggerFactory.getLogger(NtsKeycloakLocationProvider.class);
    public static boolean disableCacheForTests = false;
    public static final String PROVIDER_NAME = "keycloak";
    public static final String ATTRIBUTE_ACTIVE = "active";
    public static final String ATTRIBUTE_CREATED_AT = "createdAt";
    public static final String ATTRIBUTE_UPDATED_AT = "updatedAt";
    public static final String ATTRIBUTE_DEACTIVATED_AT = "deactivatedAt";
    public static final String ATTRIBUTE_PHONE = "phoneNumber";
    public static final String ATTRIBUTE_ADDRESS_1 = "address1";
    public static final String ATTRIBUTE_ADDRESS_2 = "address2";
    public static final String ATTRIBUTE_COUNTRY = "country";
    public static final String ATTRIBUTE_COUNTRY_CODE = "countryCode";
    public static final String ATTRIBUTE_LOCALIZED_COUNTRY_NAME = "localizedCountryName";
    public static final String ATTRIBUTE_CITY = "city";
    public static final String ATTRIBUTE_PROVINCE = "province";
    public static final String ATTRIBUTE_PROVINCE_CODE = "provinceCode";
    public static final String ATTRIBUTE_LOCALIZED_PROVINCE_NAME = "localizedProvinceName";
    public static final String ATTRIBUTE_ZIP = "zip";
    public static final String ATTRIBUTE_ADDRESS_VERIFIED = "addressVerified";
    private final NtsKeycloakLocationProperties keycloakLocationProperties;
    private final NtsKeycloakClient keycloakClient;
    private final ReactiveRedisOperations<String, Map<Long, NtsDefaultLocationDTO>> locationsRedisOps;

    public NtsKeycloakLocationProvider(NtsKeycloakLocationProperties keycloakLocationProperties, NtsKeycloakClient keycloakClient, ReactiveRedisOperations<String, Map<Long, NtsDefaultLocationDTO>> locationsRedisOps) {
        this.keycloakLocationProperties = keycloakLocationProperties;
        this.keycloakClient = keycloakClient;
        this.locationsRedisOps = locationsRedisOps;
        this.validateKeycloakProperties();
    }

    private void validateKeycloakProperties() {
        if (StringUtils.isBlank((CharSequence)this.keycloakLocationProperties.getAdminBaseUrl())) {
            throw new RuntimeException("Keycloak provider requires property nts.helper.location.keycloak.admin-base-url");
        }
        if (StringUtils.isBlank((CharSequence)this.keycloakLocationProperties.getInternalClientId())) {
            throw new RuntimeException("Keycloak provider requires property nts.helper.location.keycloak.internal-client-id");
        }
    }

    @Override
    public Mono<Map<Long, NtsDefaultLocationDTO>> findAll() {
        return this.getCacheLocations().switchIfEmpty(Mono.defer(() -> {
            String clientId = this.keycloakLocationProperties.getInternalClientId();
            return this.keycloakClient.findClientRoles(clientId, false).map(this::toLocations).map(items -> items.stream().collect(Collectors.toMap(NtsDefaultLocationDTO::getId, v -> v))).flatMap(this::setCacheLocations);
        }));
    }

    private Mono<Map<Long, NtsDefaultLocationDTO>> getCacheLocations() {
        if (disableCacheForTests) {
            return Mono.empty();
        }
        String cacheKey = this.generateCacheKey();
        return this.locationsRedisOps.opsForValue().get((Object)cacheKey);
    }

    private String generateCacheKey() {
        return this.keycloakLocationProperties.getCacheKeyPrefix() + "locations_by_id";
    }

    private Mono<Map<Long, NtsDefaultLocationDTO>> setCacheLocations(Map<Long, NtsDefaultLocationDTO> items) {
        if (disableCacheForTests) {
            return Mono.just(items);
        }
        String cacheKey = this.generateCacheKey();
        return this.locationsRedisOps.opsForValue().set((Object)cacheKey, items).thenReturn(items);
    }

    private List<NtsDefaultLocationDTO> toLocations(Collection<KeycloakClientRole> clientRoles) {
        return clientRoles.stream().map(this::toLocation).collect(Collectors.toList());
    }

    private NtsDefaultLocationDTO toLocation(KeycloakClientRole clientRole) {
        log.trace("toLocationDTO clientRole={}", (Object)clientRole);
        Map<String, List<String>> attributes = clientRole.getAttributes();
        return NtsLocationDTO.newDefaultBuilder().id(Long.valueOf(Long.parseUnsignedLong(clientRole.getName()))).name(clientRole.getDescription()).phone((String)this.singleAttribute(attributes, ATTRIBUTE_PHONE).orElse(null)).address1((String)this.singleAttribute(attributes, ATTRIBUTE_ADDRESS_1).orElse(null)).address2((String)this.singleAttribute(attributes, ATTRIBUTE_ADDRESS_2).orElse(null)).country((String)this.singleAttribute(attributes, ATTRIBUTE_COUNTRY).orElse(null)).countryCode((String)this.singleAttribute(attributes, ATTRIBUTE_COUNTRY_CODE).orElse(null)).localizedCountryName((String)this.singleAttribute(attributes, ATTRIBUTE_LOCALIZED_COUNTRY_NAME).orElse(null)).city((String)this.singleAttribute(attributes, ATTRIBUTE_CITY).orElse(null)).province((String)this.singleAttribute(attributes, ATTRIBUTE_PROVINCE).orElse(null)).provinceCode((String)this.singleAttribute(attributes, ATTRIBUTE_PROVINCE_CODE).orElse(null)).localizedProvinceName((String)this.singleAttribute(attributes, ATTRIBUTE_LOCALIZED_PROVINCE_NAME).orElse(null)).zip((String)this.singleAttribute(attributes, ATTRIBUTE_ZIP).orElse(null)).addressVerified(this.parseBooleanAttribute(attributes, ATTRIBUTE_ADDRESS_VERIFIED).orElse(false).booleanValue()).active(this.parseBooleanAttribute(attributes, ATTRIBUTE_ACTIVE).orElse(false).booleanValue()).deactivatedAt((Instant)this.parseInstantAttribute(attributes, ATTRIBUTE_DEACTIVATED_AT).orElse(null)).createdAt((Instant)this.parseInstantAttribute(attributes, ATTRIBUTE_CREATED_AT).orElse(null)).updatedAt((Instant)this.parseInstantAttribute(attributes, ATTRIBUTE_UPDATED_AT).orElse(null)).customAttributes(this.toCustomAttributes(attributes)).build();
    }

    private List<NtsDefaultAttributeDTO> toCustomAttributes(Map<String, List<String>> input) {
        if (this.keycloakLocationProperties.getCustomAttributeKeys().isEmpty() || input.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<NtsDefaultAttributeDTO> attributes = new ArrayList<NtsDefaultAttributeDTO>();
        this.keycloakLocationProperties.getCustomAttributeKeys().stream().filter(input::containsKey).forEach(key -> {
            List values = (List)input.get(key);
            if (values == null || values.isEmpty() || StringUtils.isEmpty((CharSequence)((CharSequence)values.get(0)))) {
                return;
            }
            String value = (String)values.get(0);
            NtsDefaultAttributeDTO attribute = NtsAttributeDTO.newBuilder().key(key).value(value).build();
            attributes.add(attribute);
        });
        return attributes;
    }

    private Optional<Boolean> parseBooleanAttribute(Map<String, List<String>> attributes, String key) {
        return this.singleAttribute(attributes, key).map(Boolean::parseBoolean);
    }

    private Optional<String> singleAttribute(Map<String, List<String>> attributes, String key) {
        if (attributes == null || !attributes.containsKey(key)) {
            return Optional.empty();
        }
        List<String> values = attributes.get(key);
        if (values == null || values.isEmpty() || StringUtils.isEmpty((CharSequence)values.get(0))) {
            return Optional.empty();
        }
        return Optional.of(values.get(0));
    }

    private Optional<Instant> parseInstantAttribute(Map<String, List<String>> attributes, String key) {
        return this.singleAttribute(attributes, key).map(Instant::parse);
    }

    @Override
    public Mono<Set<Long>> findAllIds() {
        return this.findAll().map(Map::keySet);
    }

    @Override
    public Mono<NtsDefaultLocationDTO> findById(Long id) {
        return this.findAll().flatMap(f -> Mono.justOrEmpty((Object)f.getOrDefault(id, null)));
    }

    @Override
    public Mono<Set<Long>> getGrantedLocationIds() {
        return this.getCurrentUserLocationBitSet().flatMap(bitSet -> {
            if (this.isGrantedAllLocations((BitSet)bitSet)) {
                return this.findAllIds();
            }
            if (bitSet.length() <= 1) {
                return Mono.just(Collections.emptySet());
            }
            return Flux.range((int)1, (int)(bitSet.length() - 1)).filter(bitSet::get).map(Integer::toUnsignedLong).collect(Collectors.toSet());
        });
    }

    private Mono<BitSet> getCurrentUserLocationBitSet() {
        return NtsSecurityUtils.getCurrentUserClaim(this.keycloakLocationProperties.getBitSetClaim()).map(this::parseBitSet).switchIfEmpty(Mono.just((Object)new BitSet()));
    }

    private BitSet parseBitSet(Object input) {
        if (input instanceof String) {
            byte[] bytes = Base64.getDecoder().decode((String)input);
            return BitSet.valueOf(bytes);
        }
        return new BitSet();
    }

    @Override
    public Mono<Boolean> isGrantedAllLocations() {
        return this.getCurrentUserLocationBitSet().map(this::isGrantedAllLocations);
    }

    private boolean isGrantedAllLocations(BitSet bitSet) {
        return bitSet.length() > 0 && bitSet.get(0);
    }

    @Override
    public Mono<Boolean> isGrantedAnyLocations(Iterable<Long> ids) {
        return this.getCurrentUserLocationBitSet().map(bitSet -> StreamSupport.stream(ids.spliterator(), false).anyMatch(id -> this.isGrantedLocation((BitSet)bitSet, (Long)id)));
    }

    @Override
    public Mono<Boolean> isGrantedAnyLocations(Long ... ids) {
        Iterable it = Stream.of(ids).collect(Collectors.toSet());
        return this.isGrantedAnyLocations(it);
    }

    @Override
    public Mono<Boolean> isGrantedLocation(@Min(value=1L) @Min(value=1L) Long id) {
        return this.getCurrentUserLocationBitSet().map(bitSet -> this.isGrantedLocation((BitSet)bitSet, id));
    }

    private boolean isGrantedLocation(BitSet bitSet, Long id) {
        if (id == null || id <= 0L) {
            return false;
        }
        return this.isGrantedAllLocations(bitSet) || id.intValue() < bitSet.length() && bitSet.get(id.intValue());
    }
}

