/*
 * Decompiled with CFR 0.152.
 */
package org.nentangso.core.service.provider;

import org.apache.commons.lang3.StringUtils;
import org.nentangso.core.service.dto.NtsLocationDTO;
import org.nentangso.core.service.provider.NtsKeycloakLocationProvider;
import org.nentangso.core.service.provider.NtsLocationProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@ConditionalOnProperty(prefix="nts.helper.location", name={"enabled"}, havingValue="true")
@Service
public class NtsLocationProviderFactory {
    private final ApplicationContext applicationContext;
    private final String provider;

    public NtsLocationProviderFactory(ApplicationContext applicationContext, @Value(value="${nts.helper.location.provider:}") String provider) {
        this.applicationContext = applicationContext;
        this.provider = provider;
    }

    public NtsLocationProvider<? extends NtsLocationDTO> getLocationProvider() {
        if (StringUtils.equals((CharSequence)this.provider, (CharSequence)"keycloak")) {
            return (NtsLocationProvider)this.applicationContext.getBean(NtsKeycloakLocationProvider.class);
        }
        throw new RuntimeException(String.format("Configuration property nts.helper.location.provider must be one of supported values %s", StringUtils.joinWith((String)", ", (Object[])new Object[]{"keycloak"})));
    }
}

